<?php
	global $schemaType;
	global $headContents;
	global $bodyContents;
	global $breadcrumbs;
	global $ShortcodeParser;

	global $cityName;
	global $stateName;
	global $stateNameShorthand;
	global $cityUrl;
	global $mapKey;

	$h3 = CMSInternals::getLastH3($bodyContents);
	//CMSInternals::deleteLastH3($bodyContents);
?>
<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/<?= $schemaType; ?>">
	<head>
		<?php include(__DIR__  . "/../includes/meta.php"); ?>
		<?= $headContents; ?>
	</head>
	<body class="<?= $_SERVER['REQUEST_URI'] !== "/" ? "interior-page" : ""; ?>">
		<?php include(__DIR__ . "/../includes/navigation.php"); ?>
		<div id="page">
			<main class="container-fluid" id="content">
				<!-- START CONTENT -->
				<section class="row py-xl-5">
					<div class="col-xl-9 col-lg-10 col-12 mx-auto pt-3 pt-lg-5 px-3 px-lg-5">
						<?= $breadcrumbs; ?>
						<?= $bodyContents; ?>
					</div>
					<div class="col-xl-9 col-lg-10 col-12 mx-auto px-3 px-lg-5">
						<?= $ShortcodeParser->parse("{{ get-reviews columns=2 truncate-body='false' limit='4' offset='0' city='$cityName' state='$stateNameShorthand' schema='true' show-empty-message='true' show-header='true' }}"); ?>
					</div>
					<?php if (!$disableGeneratedMap){ ?>
					<div class="col-xl-9 col-lg-10 col-12 mx-auto pb-3 pb-lg-5 px-3 px-lg-5">
						<?php if ($cityUrl != ""){ ?>
						<div class="text-center">
							<div class="my-3">
								<a class="btn btn-primary" target="_blank" rel="noopener" href="<?= $cityUrl; ?>">
									<i class="fas fa-map-marker-alt mr-1"></i> <?= $cityName; ?>, <?= $stateName; ?>
								</a>
							</div>
						</div>
						<?php } ?>
						<div class="ratio ratio-21x9 mb-3">
							<iframe src="https://www.google.com/maps/embed/v1/place?key=<?= $mapKey ?>&q=<?= preg_replace("/[\s]/i", "+", $cityName); ?>+<?= preg_replace("/[\s]/i", "+", $stateName); ?>"></iframe>
						</div>
					</div>
					<?php } ?>
				</section>
				<!-- END CONTENT -->

				<?php include(__DIR__ . "/../includes/cta.php"); ?>
			</main>
		</div>
		<?php include(__DIR__ . "/../includes/footer.php"); ?>
	</body>
</html>
