<?php

	namespace ContentHelperTests;

	require_once __DIR__ . "/../../vendor/autoload.php";

	use ContentHelper\ContentHelper;
	use PHPUnit\Framework\TestCase;

	class ContentHelperTest extends TestCase
	{
		public function testStripAccents(): void{
			$testString = "cover-lumières-de-noel-St-Sauveur.jpg";
			$expectedResult = "cover-lumieres-de-noel-St-Sauveur.jpg";

			$strippedString = ContentHelper::stripAccents($testString);
			$this->assertEquals(
				expected: $expectedResult,
				actual: $strippedString,
			);
		}
	}
