<?php

	namespace Page;

	use Accounts\Account;
	use Accounts\AccountCookieSession;
	use Page\PageAttribute\PageAttribute;
	use Page\PageAttribute\PageAttributePageValue;
	use PHPUnit\Framework\TestCase;
	use Roles\Permission;
	use Roles\PermissionCategories;
	use Roles\Role;
	use Uplift\Exceptions\NoObjectFound;

	final class PageTests extends TestCase
	{

		public function testGetPageAttributeValue(): void
		{
			// Create a test page
			$testPage = new Page();
			$testPage->pageName = "test_page_" . time();
			$testPage->save();

			// Create a new PageAttribute
			$pageAttribute = new PageAttribute();
			$pageAttribute->name = "test_attribute";
			$pageAttribute->save();

			// Set which page types it is available on
			$pageAttribute->setAvailablePageTypes([PageType::General->name]);

			// Create a value for this page attribute to be on $testPage
			$pageAttributeValue = new PageAttributePageValue();
			$pageAttributeValue->pageID = $testPage->id;
			$pageAttributeValue->pageAttributeID = $pageAttribute->id;
			$pageAttributeValue->value = "test_value";
			$pageAttributeValue->save();

			// Fetch the page attribute by the value ID

			$attributeValue = $testPage->getAttributeValue($pageAttributeValue->id);

			$this->assertNotNull(
				actual: $attributeValue,
			);

			// Clean up
			$pageAttributeValue->delete();
			$pageAttribute->delete();
			$testPage->delete();
		}

		public function testGetPageAttributeValueThrowsException(): void
		{
			// Create a test page
			$testPage = new Page();
			$testPage->pageName = "test_page_" . time();
			$testPage->save();

			$this->expectException(
				exception: NoObjectFound::class,
			);

			$testPage->getAttributeValue(random_int(500,10000));
			$testPage->delete();
		}

		public function testGetPageAttributeValueFromAttributeID(): void
		{
			// Create a test page
			$testPage = new Page();
			$testPage->pageName = "test_page_" . time();
			$testPage->save();

			// Create a new PageAttribute
			$pageAttribute = new PageAttribute();
			$pageAttribute->name = "test_attribute";
			$pageAttribute->save();

			// Set which page types it is available on
			$pageAttribute->setAvailablePageTypes([PageType::General->name]);

			// Create a value for this page attribute to be on $testPage
			$pageAttributeValue = new PageAttributePageValue();
			$pageAttributeValue->pageID = $testPage->id;
			$pageAttributeValue->pageAttributeID = $pageAttribute->id;
			$pageAttributeValue->value = "test_value";
			$pageAttributeValue->save();

			// Fetch the page attribute by the attribute ID
			$attributeValue = $testPage->getAttributeValueFromAttributeID($pageAttribute->id);

			$this->assertNotNull(
				actual: $attributeValue,
			);

			// Clean up
			$pageAttributeValue->delete();
			$pageAttribute->delete();
			$testPage->delete();
		}

		public function testGetPageAttributeValueFromAttributeIDThrowsException(): void
		{
			// Create a test page
			$testPage = new Page();
			$testPage->pageName = "test_page_" . time();
			$testPage->save();

			$this->expectException(
				exception: NoObjectFound::class,
			);

			$testPage->getAttributeValueFromAttributeID(random_int(500,10000));
			$testPage->delete();
		}
	}