<?php
	require_once __DIR__ . "/../../vendor/autoload.php";
    require_once __DIR__ . "/../nox-env.php";

	use MonologWrapper\MonologWrapper;
	use Nox\Nox;
    use Accounts\Account;
    use Nox\ORM\Abyss;
	use Nox\ORM\ColumnQuery;
	use Nox\ORM\DatabaseCredentials;
	use Roles\Role;

	// Load the source directory
    $nox = new Nox();
    $nox->setSourceCodeDirectory(__DIR__ . "/../src");

    // Load the credentials for any and all databases used by the models
    Abyss::addCredentials(new DatabaseCredentials(
        host: NoxEnv::MYSQL_HOST,
        username: NoxEnv::MYSQL_USERNAME,
        password: NoxEnv::MYSQL_PASSWORD,
        database: NoxEnv::MYSQL_DB_NAME,
        port: NoxEnv::MYSQL_PORT,
    ));

    $abyss = new Abyss();

	// Set logger to STDOUT
	$logger = MonologWrapper::getLoggerWithSTDOutStream();

	// Creates a CMS account via the CLI
	$logger->info("Available accounts below:\n");

	/** @var Account $account */
	foreach(Account::query() as $account){
		print("({$account->id}) {$account->getFullName()} | Username: {$account->username}\n");
	}

	print("Type the ID of the account to change the password of: ");
	$idChosen = (int) trim(fgets(STDIN));
	$account = Account::fetch($idChosen);

	if ($account === null){
		$logger->error("Invalid account ID.");
		exit();
	}

	print("Type a new password: ");

	$newPassword = trim(fgets(STDIN));
	$account->password = password_hash($newPassword, PASSWORD_DEFAULT);
	$account->save();
	$logger->info("Account password updated.");