<?php

	use Composer\InstalledVersions;
	use Composer\Semver\Semver;
	use Composer\Semver\VersionParser;

	require_once __DIR__ . "/../../vendor/autoload.php";
    require_once __DIR__ . "/../nox-env.php";

	$composerJSON = file_get_contents(__DIR__ . "/../../composer.json");
	$composerData = json_decode($composerJSON, true);
	$requirements = $composerData['require'];

	foreach($requirements as $packageName=>$versionRequirement){
		$packageName = strtolower($packageName);
		if ($packageName === "php"){
			print("PHP requirement check\n");
			if (Semver::satisfies(PHP_VERSION, $versionRequirement)){
				print("Current PHP version is satisfied.\n");
			}else{
				print("[Error] PHP version mismatch.\n");
			}
		}elseif (str_starts_with($packageName, "ext-")){
			$extensionName = substr($packageName, 4);
			$extensionVersion = phpversion($extensionName);
			if ($extensionVersion !== false) {
				print("Checking version requirement of extension: $extensionName\n");
				if (Semver::satisfies($extensionVersion, $versionRequirement)) {
					print($extensionName . " satisfies version.\n");
				} else {
					print("[Error] $extensionName Bad version match.\n");
				}
			}else{
				print("[Error] $extensionName is not installed.\n");
			}
		}else{
			// Normal package
			if (InstalledVersions::isInstalled($packageName)){
				if (InstalledVersions::satisfies(new VersionParser(), $packageName, $versionRequirement)){
					print("$packageName satisfies version requirements.\n");
				}else{
					print("[Error] $packageName version mismatch.\n");
				}
			}else{
				print("[Error] $packageName not installed.\n");
			}
		}
	}
