<?php
	require_once __DIR__ . "/../../vendor/autoload.php";
    require_once __DIR__ . "/../nox-env.php";

	use Monolog\Handler\StreamHandler;
	use MonologWrapper\MonologWrapper;
	use Nox\Nox;
    use Accounts\Account;
    use Nox\ORM\Abyss;
	use Nox\ORM\ColumnQuery;
	use Nox\ORM\DatabaseCredentials;
	use Roles\Role;

	// Load the source directory
    $nox = new Nox();
    $nox->setSourceCodeDirectory(__DIR__ . "/../src");

    // Load the credentials for any and all databases used by the models
    Abyss::addCredentials(new DatabaseCredentials(
        host: NoxEnv::MYSQL_HOST,
        username: NoxEnv::MYSQL_USERNAME,
        password: NoxEnv::MYSQL_PASSWORD,
        database: NoxEnv::MYSQL_DB_NAME,
        port: NoxEnv::MYSQL_PORT,
    ));

    $abyss = new Abyss();

	// Set logger to STDOUT
	$logger = MonologWrapper::getLoggerWithSTDOutStream();

	// Creates a CMS account via the CLI
	$logger->info("Creating a new account. Enter the account's username below\n");

	$username = trim(fgets(STDIN));

	$logger->info(sprintf("Username will be %s. Enter the password for the account below\n", $username));

	$password = trim(fgets(STDIN));

	/** @var Role $role */
	$role = Role::queryOne(
		(new ColumnQuery())
			->where("can_be_deleted","=","0")
	);

	$newAccount = new Account();
	$newAccount->email = "";
	$newAccount->firstName = "NoFirstName";
	$newAccount->lastName = "NoLastName";
	$newAccount->creationTime = time();
	$newAccount->username = $username;
	$newAccount->roleID = $role->id;
	$newAccount->password = password_hash(
		password:$password,
		algo:PASSWORD_DEFAULT,
	);

	$newAccount->save();

	$logger->info(sprintf("Account created with ID %d. By default, it is set to an administratve, undeletable role. You may want to change this.\n", $newAccount->id));