<?php
	require_once __DIR__ . "/../../vendor/autoload.php";
    require_once __DIR__ . "/../nox-env.php";

	use MonologWrapper\MonologWrapper;
	use Nox\Nox;
	use Nox\ORM\ColumnQuery;
	use Roles\PermissionAlreadyExists;
	use Roles\PermissionCategories;
	use Roles\PermissionsService;
	use Roles\Role;
	use Accounts\Account;
	use Nox\ORM\Abyss;
	use Nox\ORM\DatabaseCredentials;

    // Load the source directory
    $nox = new Nox();
    $nox->setSourceCodeDirectory(__DIR__ . "/../src");

    // Load the credentials for any and all databases used by the models
    Abyss::addCredentials(new DatabaseCredentials(
        host: NoxEnv::MYSQL_HOST,
        username: NoxEnv::MYSQL_USERNAME,
        password: NoxEnv::MYSQL_PASSWORD,
        database: NoxEnv::MYSQL_DB_NAME,
        port: NoxEnv::MYSQL_PORT,
    ));

    $abyss = new Abyss();

	// Creates a CMS account via the CLI
	$logger = MonologWrapper::getLoggerWithSTDOutStream();
	$logger->info("Enter the user's account ID below to give all permissions to:\n");

	$userID = (int) trim(fgets(STDIN));
	/** @var Account $account */
	$account = Account::fetch($userID);

	if ($account !== null) {
		$logger->info(sprintf("Giving all permissions to user %d - %s\n", $userID, $account->getFullName()));

		// Find the undeletable role
		/** @var Role $masterRole */
		$masterRole = Role::queryOne(
			columnQuery: (new ColumnQuery())
				->where("can_be_deleted","=",0)
		);

		if ($masterRole !== null) {

			$account->roleID = $masterRole->id;
			$account->save();

			// Fetch all permissions and give them to the role
			foreach (PermissionCategories::cases() as $permissionCategory) {
				$existingPermission = $masterRole->getPermission($permissionCategory);
				if ($existingPermission){
					if ($existingPermission->isEnabled === 0){
						$existingPermission->isEnabled = true;
						$existingPermission->save();
					}
				}else{
					// Create it
					try {
						$permission = PermissionsService::createPermission(
							role: $masterRole,
							category: $permissionCategory,
						);
						$permission->isEnabled = 1;
						$permission->save();
					} catch (PermissionAlreadyExists) {
						// Won't happen
					}
				}
			}
		}else{
			$logger->info("No role found in the database that has can_be_deleted set to 0. This script requires an undeletable role.");
		}

	}else{
		$logger->info(sprintf("There is no account with the ID %d\n", $userID));
	}