<?php
	require_once __DIR__ . "/../../vendor/autoload.php";
	require_once __DIR__ . "/../nox-env.php";

	use Nox\Nox;
	use Nox\ORM\Abyss;
	use Nox\ORM\DatabaseCredentials;
	use System\Updater\UpdaterService;

	// Load the source directory
	$nox = new Nox();
	$nox->setSourceCodeDirectory(__DIR__ . "/../src");

	// Load the credentials for any and all databases used by the models
	Abyss::addCredentials(new DatabaseCredentials(
		host: NoxEnv::MYSQL_HOST,
		username: NoxEnv::MYSQL_USERNAME,
		password: NoxEnv::MYSQL_PASSWORD,
		database: NoxEnv::MYSQL_DB_NAME,
		port: NoxEnv::MYSQL_PORT,
	));

	if (NoxEnv::DEV_ENV !== "development"){
		print("Will not test download or install the update in a non-development environment.");
		exit();
	}

	$location = UpdaterService::downloadUpdatedBuild();
	$extractionLocation = __DIR__ . "/../../extraction-test";
	UpdaterService::installUpdate(
		updatePackageLocation: $location,
		extractionLocation:$extractionLocation,
	);
