function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ContentLengthIndicator = /*#__PURE__*/function () {
  function ContentLengthIndicator() {
    var _this = this;
    _classCallCheck(this, ContentLengthIndicator);
    _defineProperty(this, "projectDescriptionBodyTextField", document.querySelector("#project-description-input"));
    _defineProperty(this, "textIndicator", document.querySelector("#content-length-text"));
    _defineProperty(this, "barIndicator", document.querySelector("#content-length-inner-optimization-bar"));
    _defineProperty(this, "primaryServiceSelectMenu", document.querySelector("#service-page-id-input"));
    _defineProperty(this, "cityPageIDSelectMenu", document.querySelector("#city-page-id-input"));
    _defineProperty(this, "projectCityLocationInput", document.querySelector("#project-location-city-input"));
    _defineProperty(this, "wordCountLabelMarks", {
      met: document.querySelector("#word-count-label-column .met"),
      notMet: document.querySelector("#word-count-label-column .not-met")
    });
    _defineProperty(this, "serviceMentionedLabelMarks", {
      met: document.querySelector("#primary-service-label-column .met"),
      notMet: document.querySelector("#primary-service-label-column .not-met")
    });
    _defineProperty(this, "cityMentionedLabelMarks", {
      met: document.querySelector("#city-label-column .met"),
      notMet: document.querySelector("#city-label-column .not-met")
    });
    this.projectDescriptionBodyTextField.addEventListener("input", function () {
      _this.onProjectDescriptionInput();
    });
    this.cityPageIDSelectMenu.addEventListener("change", function () {
      _this.updateContentLengthQualityFields();
    });
    this.projectCityLocationInput.addEventListener("change", function () {
      _this.updateContentLengthQualityFields();
    });
  }
  return _createClass(ContentLengthIndicator, [{
    key: "onProjectDescriptionInput",
    value: function onProjectDescriptionInput() {
      this.updateContentLengthQualityFields();
    }
    /**
     * Called when refreshing of the quality bar and text is needed.
     */
  }, {
    key: "updateContentLengthQualityFields",
    value: function updateContentLengthQualityFields() {
      var percentage = this.getQualityPercentage();
      // Min 10%
      if (percentage < 0.1) {
        percentage = 0.1;
      }
      this.barIndicator.style.width = "".concat(percentage * 100, "%");
      // Handle verbiage
      if (percentage < 0.5) {
        this.textIndicator.textContent = "Poor";
        this.barIndicator.setAttribute("quality", "poor");
      } else if (percentage < 0.75) {
        this.textIndicator.textContent = "Fair";
        this.barIndicator.setAttribute("quality", "fair");
      } else {
        this.textIndicator.textContent = "Good";
        this.barIndicator.setAttribute("quality", "good");
      }
    }
    /**
     * Quality is determined by how much content and how keyword optimized the project description is.
     * Key phrase optimization gains points when a service and location are selected in the project form, and the
     * service and location are also present in the description content.
     */
  }, {
    key: "getQualityPercentage",
    value: function getQualityPercentage() {
      // Maximum weight for just content with no key phrase optimization is 50%.
      // 25% for service area optimization
      // 25% for city and state optimization
      // Word count ranges
      var minWordCount = 20;
      var maxWordCountToConsider = 100;
      // Define the scoring weights
      var maxWordCountWeight = 0.5;
      var locationOptimizationWeight = 0.25;
      var mainServiceOptimizationWeight = 0.25;
      // Accumulator for total percentage
      var totalWeight = 0; // 0 to 1 percentage
      // Interpolate percentage from 20-100 words.
      var numWords = this.countWordsInProjectDescription();
      if (numWords > minWordCount) {
        var wordCountRange = maxWordCountToConsider - minWordCount;
        var interpolationPercentage = numWords / wordCountRange;
        // Clamp it at 100%
        if (interpolationPercentage > 1) {
          interpolationPercentage = 1;
        }
        this.updateWordCountLabel(interpolationPercentage >= 1);
        totalWeight += maxWordCountWeight * interpolationPercentage;
      } else {
        this.updateWordCountLabel(false);
      }
      // Consider if the primary service is in the content
      var projectDescription = this.projectDescriptionBodyTextField.value.trim();
      if (this.primaryServiceSelectMenu.value !== "-1" && this.primaryServiceSelectMenu.value !== "0") {
        var primaryServiceName = this.primaryServiceSelectMenu.options[this.primaryServiceSelectMenu.selectedIndex];
        if (projectDescription.toLowerCase().includes(primaryServiceName.textContent.toLowerCase())) {
          totalWeight += mainServiceOptimizationWeight;
          this.updateServiceLabel(true);
        } else {
          this.updateServiceLabel(false);
        }
      } else {
        this.updateServiceLabel(false);
      }
      // Consider if the city is in the content
      if (this.cityPageIDSelectMenu.value !== "-1" && this.cityPageIDSelectMenu.value !== "0") {
        var cityPageName = this.cityPageIDSelectMenu.options[this.cityPageIDSelectMenu.selectedIndex].textContent;
        var city = this.getCityFromCityPageName(cityPageName);
        if (projectDescription.toLowerCase().includes(city.toLowerCase())) {
          totalWeight += locationOptimizationWeight;
          this.updateCityLabel(true);
        } else {
          this.updateCityLabel(false);
        }
      } else if (this.cityPageIDSelectMenu.value === "-1") {
        // Custom city
        var _city = this.projectCityLocationInput.value.trim();
        if (_city.length > 0) {
          if (projectDescription.toLowerCase().includes(_city.toLowerCase())) {
            totalWeight += locationOptimizationWeight;
            this.updateCityLabel(true);
          } else {
            this.updateCityLabel(false);
          }
        } else {
          this.updateCityLabel(false);
        }
      } else {
        this.updateCityLabel(false);
      }
      return totalWeight;
    }
  }, {
    key: "countWordsInProjectDescription",
    value: function countWordsInProjectDescription() {
      var text = this.projectDescriptionBodyTextField.value.trim();
      return text.split(" ").length;
    }
    /**
     * City pages usually have the format "City, ST" and we only want the City.
     */
  }, {
    key: "getCityFromCityPageName",
    value: function getCityFromCityPageName(cityPageName) {
      if (cityPageName.includes(",")) {
        return cityPageName.split(",")[0];
      } else {
        return cityPageName;
      }
    }
    /**
     * Shows or hides the word count met checkmark
     */
  }, {
    key: "updateWordCountLabel",
    value: function updateWordCountLabel(isWordCountMet) {
      if (isWordCountMet) {
        this.wordCountLabelMarks.met.style.display = null;
        this.wordCountLabelMarks.notMet.style.display = "none";
      } else {
        this.wordCountLabelMarks.met.style.display = "none";
        this.wordCountLabelMarks.notMet.style.display = null;
      }
    }
    /**
     * Shows or hides the service mentioned checkmark
     */
  }, {
    key: "updateServiceLabel",
    value: function updateServiceLabel(isServiceMentioned) {
      if (isServiceMentioned) {
        this.serviceMentionedLabelMarks.met.style.display = null;
        this.serviceMentionedLabelMarks.notMet.style.display = "none";
      } else {
        this.serviceMentionedLabelMarks.met.style.display = "none";
        this.serviceMentionedLabelMarks.notMet.style.display = null;
      }
    }
    /**
     * Shows or hides the city mentioned checkmark
     */
  }, {
    key: "updateCityLabel",
    value: function updateCityLabel(isCityMentioned) {
      if (isCityMentioned) {
        this.cityMentionedLabelMarks.met.style.display = null;
        this.cityMentionedLabelMarks.notMet.style.display = "none";
      } else {
        this.cityMentionedLabelMarks.met.style.display = "none";
        this.cityMentionedLabelMarks.notMet.style.display = null;
      }
    }
  }]);
}();
export { ContentLengthIndicator as default };