function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var NoCityKeyword = /*#__PURE__*/function () {
  function NoCityKeyword() {
    var _this = this;
    _classCallCheck(this, NoCityKeyword);
    _defineProperty(this, "projectDescriptionTextField", document.querySelector("#project-description-input"));
    _defineProperty(this, "alertBox", document.querySelector("#no-city-keyword-warning"));
    _defineProperty(this, "cityInput", document.querySelector("#project-location-city-input"));
    _defineProperty(this, "cityPageSelector", document.querySelector("#city-page-id-input"));
    this.projectDescriptionTextField.addEventListener("input", function () {
      _this.onProjectDescriptionInput();
    });
    this.cityInput.addEventListener("input", function () {
      _this.onCityInputChanged();
    });
    this.cityPageSelector.addEventListener("change", function () {
      _this.onCityInputChanged();
    });
  }
  return _createClass(NoCityKeyword, [{
    key: "onProjectDescriptionInput",
    value: function onProjectDescriptionInput() {
      var city = this.getCity().trim();
      if (city.length > 0) {
        // Find this key phrase in the content
        if (this.doesProjectDescriptionIncludeText(city)) {
          // We're good
          this.hideWarning();
        } else {
          // Warn them
          this.showWarning();
        }
      } else {
        this.hideWarning();
      }
    }
  }, {
    key: "onCityInputChanged",
    value: function onCityInputChanged() {
      this.onProjectDescriptionInput();
    }
    /**
     * Fetches the value from the city input field or the city select menu
     */
  }, {
    key: "getCity",
    value: function getCity() {
      if (this.cityPageSelector.value === "-1") {
        return this.cityInput.value;
      } else if (parseInt(this.cityPageSelector.value) > 0) {
        // City page ID
        var cityPageName = this.cityPageSelector.options[this.cityPageSelector.selectedIndex].textContent;
        return this.getCityFromCityPageName(cityPageName);
      }
      return "";
    }
  }, {
    key: "doesProjectDescriptionIncludeText",
    value: function doesProjectDescriptionIncludeText(textToCheckFor) {
      return this.projectDescriptionTextField.value.toLowerCase().includes(textToCheckFor.toLowerCase());
    }
  }, {
    key: "showWarning",
    value: function showWarning() {
      this.alertBox.style.display = null;
    }
  }, {
    key: "hideWarning",
    value: function hideWarning() {
      this.alertBox.style.display = "none";
    }
    /**
     * City pages usually have the format "City, ST" and we only want the City.
     */
  }, {
    key: "getCityFromCityPageName",
    value: function getCityFromCityPageName(cityPageName) {
      if (cityPageName.includes(",")) {
        return cityPageName.split(",")[0];
      } else {
        return cityPageName;
      }
    }
  }]);
}();
export { NoCityKeyword as default };