function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
* Programmatic confirmation modal for general action confirming use.
* Such as confirming a deletion act after the button is pressed.
* Uses asynchronous programming to send confirm/cancel events back
* to the calling scope.
*/
export var ConfirmModal = /*#__PURE__*/function () {
  function ConfirmModal(id) {
    var _this = this;
    _classCallCheck(this, ConfirmModal);
    _defineProperty(this, "Modal", void 0);
    _defineProperty(this, "BSModal", void 0);
    _defineProperty(this, "AcceptPromise", null);
    _defineProperty(this, "ActionPromise", void 0);
    this.Modal = this.Build(id);
    /** @type {Modal} */
    this.BSModal = new bootstrap.Modal(this.Modal);
    this.AcceptPromise = null;
    this.ActionPromise = new Promise(function (accept, reject) {
      // Leak the "accept" function out of the scope
      // so other functions can call it
      _this.AcceptPromise = accept;
    });
    // Connect events
    this.Modal.addEventListener("hide.bs.modal", function () {
      _this.AcceptPromise(false);
      _this.Modal.remove();
    });
    this.Modal.querySelector(".modal-confirm-button").addEventListener("click", function () {
      _this.AcceptPromise(true);
    });
  }
  /**
  * Creates a new promise that can be awaited by a calling function
  * for when action is taken on the modal
  * @returns {Promise} Boolean when accepted. False if the modal is dismissed.
  */
  return _createClass(ConfirmModal, [{
    key: "ActionTaken",
    value: function ActionTaken() {
      return this.ActionPromise;
    }
    /**
    * Sets the modal's title
    * @param {string} title
    */
  }, {
    key: "SetTitle",
    value: function SetTitle(title) {
      this.Modal.querySelector(".modal-title").textContent = title;
    }
    /**
    * Sets the modal's textual content. Does not accept HTML
    * @param {string} content
    */
  }, {
    key: "SetContent",
    value: function SetContent(content) {
      this.Modal.querySelector(".modal-body-inner").textContent = content;
    }
    /**
    * Sets the modal's HTML content.
    * @param {string} htmlContent
    */
  }, {
    key: "SetHTMLContent",
    value: function SetHTMLContent(htmlContent) {
      this.Modal.querySelector(".modal-body-inner").innerHTML = htmlContent;
    }
    /**
    * Sets the text of the confirm button
    * @param {string} text
    */
  }, {
    key: "SetConfirmButtonText",
    value: function SetConfirmButtonText(text) {
      this.Modal.querySelector(".modal-confirm-button").textContent = text;
    }
    /**
     * Sets the HTML of the confirm button
     * @param {string} html
     */
  }, {
    key: "SetConfirmButtonHTML",
    value: function SetConfirmButtonHTML(html) {
      var _this2 = this;
      this.Modal.querySelector(".modal-confirm-button").innerHTML = html;
      // Confirm event needs to be reconnected
      this.Modal.querySelector(".modal-confirm-button").addEventListener("click", function () {
        _this2.AcceptPromise(true);
      });
    }
    /**
    * Shows the modal
    */
  }, {
    key: "ShowModal",
    value: function ShowModal() {
      this.BSModal.show();
    }
    /**
    * Hides the modal
    */
  }, {
    key: "HideModal",
    value: function HideModal() {
      this.BSModal.hide();
    }
    /**
    * Hides the cancel button
    */
  }, {
    key: "HideSecondaryButton",
    value: function HideSecondaryButton() {
      this.Modal.querySelector(".modal-cancel-button").style.display = "none";
    }
    /**
    * Builds the DOM modal
    * @param {string} id
    * @returns {HTMLDivElement} The modal
    */
  }, {
    key: "Build",
    value: function Build(id) {
      var modal = document.createElement("div");
      modal.classList.add("modal");
      modal.setAttribute("id", id);
      modal.setAttribute("tabindex", "-1");
      modal.setAttribute("role", "dialog");
      modal.setAttribute("aria-hidden", "true");
      modal.innerHTML = "\n\t\t\t<div class=\"modal-dialog\">\n\t\t\t\t<div class=\"modal-content\">\n\t\t\t\t\t<div class=\"modal-header bg-danger text-white\">\n\t\t\t\t\t\t<h4 class=\"modal-title\"></h4>\n\t\t\t\t\t\t<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\" aria-label=\"Close\"></button>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"modal-body\">\n\t\t\t\t\t\t<p class=\"modal-body-inner\"></p>\n\t\t\t\t\t\t<div class=\"submit-error my-2 p-2 text-white bg-danger\" style=\"display:none;\"></div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"modal-footer\">\n\t\t\t\t\t\t<button type=\"button\" class=\"modal-confirm-button btn btn-danger\"></button>\n\t\t\t\t\t\t<button type=\"button\" class=\"modal-cancel-button btn btn-gray\" data-bs-dismiss=\"modal\">\n\t\t\t\t\t\t\t<span>Cancel</span>\n\t\t\t\t\t\t</button>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t";
      document.body.append(modal);
      return modal;
    }
  }, {
    key: "Cleanup",
    value: function Cleanup() {
      this.BSModal.hide();
    }
  }]);
}();