function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var NoCityKeyword = /*#__PURE__*/function () {
  function NoCityKeyword() {
    var _this = this;
    _classCallCheck(this, NoCityKeyword);
    _defineProperty(this, "projectDescriptionTextField", document.querySelector("#project-description-input"));
    _defineProperty(this, "alertBox", document.querySelector("#no-city-keyword-warning"));
    _defineProperty(this, "cityInput", document.querySelector("#project-location-city-input"));
    _defineProperty(this, "cityPageSelector", document.querySelector("#city-page-id-input"));
    this.projectDescriptionTextField.addEventListener("input", function () {
      _this.onProjectDescriptionInput();
    });
    this.cityInput.addEventListener("input", function () {
      _this.onCityInputChanged();
    });
    this.cityPageSelector.addEventListener("change", function () {
      _this.onCityInputChanged();
    });
  }
  _createClass(NoCityKeyword, [{
    key: "onProjectDescriptionInput",
    value: function onProjectDescriptionInput() {
      var city = this.getCity().trim();
      if (city.length > 0) {
        // Find this key phrase in the content
        if (this.doesProjectDescriptionIncludeText(city)) {
          // We're good
          this.hideWarning();
        } else {
          // Warn them
          this.showWarning();
        }
      } else {
        this.hideWarning();
      }
    }
  }, {
    key: "onCityInputChanged",
    value: function onCityInputChanged() {
      this.onProjectDescriptionInput();
    }

    /**
     * Fetches the value from the city input field or the city select menu
     */
  }, {
    key: "getCity",
    value: function getCity() {
      if (this.cityPageSelector.value === "-1") {
        return this.cityInput.value;
      } else if (parseInt(this.cityPageSelector.value) > 0) {
        // City page ID
        var cityPageName = this.cityPageSelector.options[this.cityPageSelector.selectedIndex].textContent;
        return this.getCityFromCityPageName(cityPageName);
      }
      return "";
    }
  }, {
    key: "doesProjectDescriptionIncludeText",
    value: function doesProjectDescriptionIncludeText(textToCheckFor) {
      return this.projectDescriptionTextField.value.toLowerCase().includes(textToCheckFor.toLowerCase());
    }
  }, {
    key: "showWarning",
    value: function showWarning() {
      this.alertBox.style.display = null;
    }
  }, {
    key: "hideWarning",
    value: function hideWarning() {
      this.alertBox.style.display = "none";
    }

    /**
     * City pages usually have the format "City, ST" and we only want the City.
     */
  }, {
    key: "getCityFromCityPageName",
    value: function getCityFromCityPageName(cityPageName) {
      if (cityPageName.includes(",")) {
        return cityPageName.split(",")[0];
      } else {
        return cityPageName;
      }
    }
  }]);
  return NoCityKeyword;
}();
export { NoCityKeyword as default };