function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var CoverPhotoFileInput = /*#__PURE__*/function () {
  function CoverPhotoFileInput() {
    var _this = this;
    _classCallCheck(this, CoverPhotoFileInput);
    _defineProperty(this, "input", document.querySelector("#cover-photo-input"));
    this.input.addEventListener("change", /** @param {InputEvent} e */function (e) {
      _this.onFileInputChanged(_this.input, e);
    });
  }

  /**
   * @param {HTMLInputElement} inputElement
   * @param {InputEvent} event
   */
  return _createClass(CoverPhotoFileInput, [{
    key: "onFileInputChanged",
    value: function onFileInputChanged(inputElement, event) {
      var file = inputElement.files[0];
      var maxFileSizeInBytes = parseInt(document.querySelector("#max-file-upload-size").getAttribute("data-in-bytes"));
      if (file) {
        // Don't let files be 95% max file size
        var paddedMaxFileSizeInBytes = 0.95 * maxFileSizeInBytes;
        var fileSize = file.size;
        if (fileSize >= paddedMaxFileSizeInBytes) {
          alert("That file is too large and cannot be submitted. We have removed it. Please optimize or resize that file to submit it.");
          inputElement.value = null;
        } else {
          // It's good
        }
      }
    }
  }]);
}();
export default CoverPhotoFileInput;