function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import IPPReelModal from "../../page-editor/modals/IPPReelModal.js";
var IPPReelForm = /*#__PURE__*/function () {
  function IPPReelForm() {
    var _this = this;
    _classCallCheck(this, IPPReelForm);
    this.form = document.querySelector("#ipp-reel-form");

    /** @property {bool} isSubmitting The current status of submission */
    this.isSubmitting = false;
    this.form.addEventListener("submit", function (e) {
      e.preventDefault();
      _this.OnSubmit();
    });
  }
  return _createClass(IPPReelForm, [{
    key: "OnSubmit",
    value: function OnSubmit() {
      var fData = new FormData(this.form);
      var submitButton = this.form.querySelector("button[type=\"submit\"]");
      var errorContainer = this.form.querySelector(".submit-error");
      if (this.isSubmitting) {
        return;
      }

      // Show the submit button as disabled
      submitButton.classList.add("disabled");
      errorContainer.style.display = "none";

      // Get all project tags included and excluded
      var includedTagIDs = [];
      var excludedTagIDs = [];
      var includeTagButtons = this.form.querySelectorAll(".ipp-reel-tag-include-button");
      var excludeTagButtons = this.form.querySelectorAll(".ipp-reel-tag-exclude-button");
      var _iterator = _createForOfIteratorHelper(includeTagButtons),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var button = _step.value;
          if (button.classList.contains("selected")) {
            includedTagIDs.push(parseInt(button.getAttribute("data-tag-id")));
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      var _iterator2 = _createForOfIteratorHelper(excludeTagButtons),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _button = _step2.value;
          if (_button.classList.contains("selected")) {
            excludedTagIDs.push(parseInt(_button.getAttribute("data-tag-id")));
          }
        }

        // Get the number of articles per page and columns
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      var numProjectsPerPage = parseInt(String(fData.get("ipp-reel-projects-per-page")));
      var numColumns = parseInt(String(fData.get("ipp-reel-num-columns")));
      if (isNaN(numProjectsPerPage)) {
        this.OnFormattedError("Number of projects is in a non-numerical format.");
        return;
      }
      if (isNaN(numColumns)) {
        this.OnFormattedError("Number of columns is in a non-numerical format.");
        return;
      }
      this.OnSuccess(numProjectsPerPage, numColumns, includedTagIDs, excludedTagIDs);
    }

    /**
     * When the form succeeds without error
     */
  }, {
    key: "OnSuccess",
    value: function OnSuccess(numProjectsPerPage, numColumns, includedTagIDs, excludedTagIDs) {
      var submitButton = this.form.querySelector("button[type=\"submit\"]");
      this.isSubmitting = false;
      submitButton.classList.remove("disabled");

      // Inject the shortcode with the known parameters
      var shortcodeText = "{{ get-ipps ipps-per-page=\"".concat(numProjectsPerPage, "\" columns=\"").concat(numColumns, "\" included-project-tags=\"").concat(includedTagIDs, "\" excluded-project-tags=\"").concat(excludedTagIDs, "\" }}");
      tinymce.activeEditor.insertContent(shortcodeText);
      IPPReelModal.hideModal();
    }

    /**
     * A readable error happened on the server in the JSON response.
     * (A status of -1 was read)
     * @param {string} err
     */
  }, {
    key: "OnFormattedError",
    value: function OnFormattedError(err) {
      var errorContainer = this.form.querySelector(".submit-error");
      var submitButton = this.form.querySelector("button[type=\"submit\"]");
      this.isSubmitting = false;
      submitButton.classList.remove("disabled");
      errorContainer.textContent = err;
      errorContainer.style.display = "block";
    }
  }]);
}();
export { IPPReelForm as default };