function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var FileEditorStates = /*#__PURE__*/function () {
  function FileEditorStates() {
    _classCallCheck(this, FileEditorStates);
    /** @type {boolean} */
    this.unsavedChanges = false;

    /** @type {?string} The root directory the Uplift application is being served from. */
    this.applicationRoot = null;

    /** @type {string} This property should never update */
    this.rootThemeDirectory = document.querySelector("#theme-root-directory").value;

    /** @type {string} Relative path */
    this.currentDirectory = document.querySelector("#directory-location-input").value;

    /** @type {string} Of the current open and active file */
    this.currentFilePath = "";

    /** @type {string[]} The history of locations the user has navigated */
    this.directoryLocationHistory = [];

    /** @type {?ContextMenu} */
    this.currentContextMenu = null;
  }

  /**
  * Removes a location entirely from the tracked directory history
  * @param {string} directoryLocation
  */
  return _createClass(FileEditorStates, [{
    key: "removeLocationFromHistory",
    value: function removeLocationFromHistory(directoryLocation) {
      while (this.directoryLocationHistory.indexOf(directoryLocation) > -1) {
        this.directoryLocationHistory.splice(this.directoryLocationHistory.indexOf(directoryLocation), 1);
      }
    }
  }]);
}();
export default new FileEditorStates();