function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(typeof e + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import FileEditorStates from "./FileEditorStates.js";
import FileEditorWrapper from "./FileEditorWrapper.js";
import EditorEndpoints from "../EditorEndpoints.js";
import Endpoints from "../../Endpoints.js";
import DeleteDirectoryMechanic from "./mechanics/DeleteDirectoryMechanic.js";
import CompileSCSSMechanics from "./mechanics/CompileSCSSMechanics.js";
import DeleteFileMechanic from "./mechanics/DeleteFileMechanic.js";
import NewDirectoryModal from "./modals/NewDirectoryModal.js";
import RenameDirectoryModal from "./modals/RenameDirectoryModal.js";
import NewFileModal from "./modals/NewFileModal.js";
import RenameFileModal from "./modals/RenameFileModal.js";
import ContextMenu from "../../utils/ContextMenu.js";
import Collapse from "./../../_external/bootstrap/collapse.js";
import SidebarLoadingOverlay from "./components/SidebarLoadingOverlay.js";
import Scheduler from "../../utils/Scheduler.js";
import Utils from "./Utils.js";

/**
* Handles the page editor page loading
* and rendering them into the sidebar
*/
var SidebarFileLoader = /*#__PURE__*/function () {
  function SidebarFileLoader() {
    var _this = this;
    _classCallCheck(this, SidebarFileLoader);
    this.directoryListingContainerDOM = document.querySelector("#content-editor-page-navigation-column");
    this.directoryListingDOM = document.querySelector("#directory-listing");
    this.backButton = document.querySelector("#back-button-directory-listing");
    this.isLoadingDirectory = false;
    var directoryToLoad = FileEditorStates.currentDirectory;
    if (directoryToLoad === "/") {
      directoryToLoad = FileEditorStates.rootThemeDirectory;
    }
    this.loadDirectory(directoryToLoad);
    this.backButton.addEventListener("click", function () {
      _this.onBackButtonClicked();
    });
    this.directoryListingContainerDOM.addEventListener("contextmenu", function (e) {
      e.preventDefault();
      e.stopPropagation();
      _this.onSidebarContextMenu(e);
    });
  }

  /**
  * When a context menu is requested on the sidebar
  * @param {Event} e
  */
  return _createClass(SidebarFileLoader, [{
    key: "onSidebarContextMenu",
    value: function onSidebarContextMenu(e) {
      // Check for an existing file editor context menu
      if (FileEditorStates.currentContextMenu) {
        FileEditorStates.currentContextMenu.cleanup();
      }
      var menu = new ContextMenu(e.pageX, e.pageY);
      FileEditorStates.currentContextMenu = menu;
      var newFolderButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-folder-plus\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M.5 3l.04.87a1.99 1.99 0 0 0-.342 1.311l.637 7A2 2 0 0 0 2.826 14H9v-1H2.826a1 1 0 0 1-.995-.91l-.637-7A1 1 0 0 1 2.19 4h11.62a1 1 0 0 1 .996 1.09L14.54 8h1.005l.256-2.819A2 2 0 0 0 13.81 3H9.828a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 6.172 1H2.5a2 2 0 0 0-2 2zm5.672-1a1 1 0 0 1 .707.293L7.586 3H2.19c-.24 0-.47.042-.684.12L1.5 2.98a1 1 0 0 1 1-.98h3.672z\"/>\n\t\t\t\t<path d=\"M13.5 10a.5.5 0 0 1 .5.5V12h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V13h-1.5a.5.5 0 0 1 0-1H13v-1.5a.5.5 0 0 1 .5-.5z\"/>\n\t\t\t</svg>\n\t\t\t<span>New folder</span>\n\t\t");
      var newFileButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-file-earmark-plus\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M8 6.5a.5.5 0 0 1 .5.5v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 .5-.5z\"/>\n\t\t\t\t<path d=\"M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5L14 4.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5h-2z\"/>\n\t\t\t</svg>\n\t\t\t<span>New file</span>\n\t\t");
      newFileButton.addEventListener("click", function () {
        NewFileModal.showModal();
        menu.cleanup();
      });
      newFolderButton.addEventListener("click", function () {
        NewDirectoryModal.showModal();
        menu.cleanup();
      });

      // Render the menu
      menu.render();
    }

    /**
    * When a context menu is requested on a directory button
    * @param {MouseEvent} e
    * @param {HTMLDivElement} directoryContainerNode The <div> containing the button
    */
  }, {
    key: "onDirectoryContextMenu",
    value: function onDirectoryContextMenu(e, directoryContainerNode) {
      // Check for an existing file editor context menu
      if (FileEditorStates.currentContextMenu) {
        FileEditorStates.currentContextMenu.cleanup();
      }
      var menu = new ContextMenu(e.pageX, e.pageY);
      FileEditorStates.currentContextMenu = menu;
      var renameDirectoryButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-input-cursor-text\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path fill-rule=\"evenodd\" d=\"M5 2a.5.5 0 0 1 .5-.5c.862 0 1.573.287 2.06.566.174.099.321.198.44.286.119-.088.266-.187.44-.286A4.165 4.165 0 0 1 10.5 1.5a.5.5 0 0 1 0 1c-.638 0-1.177.213-1.564.434a3.49 3.49 0 0 0-.436.294V7.5H9a.5.5 0 0 1 0 1h-.5v4.272c.1.08.248.187.436.294.387.221.926.434 1.564.434a.5.5 0 0 1 0 1 4.165 4.165 0 0 1-2.06-.566A4.561 4.561 0 0 1 8 13.65a4.561 4.561 0 0 1-.44.285 4.165 4.165 0 0 1-2.06.566.5.5 0 0 1 0-1c.638 0 1.177-.213 1.564-.434.188-.107.335-.214.436-.294V8.5H7a.5.5 0 0 1 0-1h.5V3.228a3.49 3.49 0 0 0-.436-.294A3.166 3.166 0 0 0 5.5 2.5.5.5 0 0 1 5 2z\"/>\n\t\t\t\t<path d=\"M10 5h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1h-4v1h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-4v1zM6 5V4H2a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4v-1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h4z\"/>\n\t\t\t</svg>\n\t\t\t<span>Rename</span>\n\t\t");
      var copyURIButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-link-45deg\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M4.715 6.542L3.343 7.914a3 3 0 1 0 4.243 4.243l1.828-1.829A3 3 0 0 0 8.586 5.5L8 6.086a1.001 1.001 0 0 0-.154.199 2 2 0 0 1 .861 3.337L6.88 11.45a2 2 0 1 1-2.83-2.83l.793-.792a4.018 4.018 0 0 1-.128-1.287z\"/>\n\t\t\t\t<path d=\"M6.586 4.672A3 3 0 0 0 7.414 9.5l.775-.776a2 2 0 0 1-.896-3.346L9.12 3.55a2 2 0 0 1 2.83 2.83l-.793.792c.112.42.155.855.128 1.287l1.372-1.372a3 3 0 0 0-4.243-4.243L6.586 4.672z\"/>\n\t\t\t</svg>\n\t\t\t<span>Copy URI</span>\n\t\t");
      menu.addSeparator();
      var deleteDirectoryButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"red\" class=\"bi bi-x-octagon-fill\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M11.46.146A.5.5 0 0 0 11.107 0H4.893a.5.5 0 0 0-.353.146L.146 4.54A.5.5 0 0 0 0 4.893v6.214a.5.5 0 0 0 .146.353l4.394 4.394a.5.5 0 0 0 .353.146h6.214a.5.5 0 0 0 .353-.146l4.394-4.394a.5.5 0 0 0 .146-.353V4.893a.5.5 0 0 0-.146-.353L11.46.146zm-6.106 4.5L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z\"/>\n\t\t\t</svg>\n\t\t\t<span>Delete folder</span>\n\t\t");
      renameDirectoryButton.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var directoryLocation, folderName;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              directoryLocation = directoryContainerNode.getAttribute("location");
              folderName = directoryContainerNode.querySelector(".directory-name").textContent;
              document.querySelector("#rename-directory-old-path-input").value = directoryLocation;
              document.querySelector("#rename-directory-new-name-input").value = folderName;
              RenameDirectoryModal.showModal();
              menu.cleanup();
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee);
      })));
      deleteDirectoryButton.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              DeleteDirectoryMechanic.deleteDirectory(directoryContainerNode.getAttribute("location"), directoryContainerNode);
              menu.cleanup();
            case 2:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      })));
      copyURIButton.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
        var result, fullSystemFilePath, relativePathFromAppRoot, browserNavigatableURI;
        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return navigator.permissions.query({
                name: "clipboard-write"
              });
            case 2:
              result = _context3.sent;
              if (!(result.state === "granted" || result.state === "prompt")) {
                _context3.next = 9;
                break;
              }
              fullSystemFilePath = directoryContainerNode.getAttribute("location");
              relativePathFromAppRoot = fullSystemFilePath.replace(FileEditorStates.applicationRoot, "");
              browserNavigatableURI = relativePathFromAppRoot.replace(new RegExp(/\\/g), "/");
              _context3.next = 9;
              return navigator.clipboard.writeText("".concat(browserNavigatableURI));
            case 9:
              menu.cleanup();
            case 10:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      })));

      // Render the menu
      menu.render();
    }

    /**
    * When a context menu is requested on a file button
    * @param {MouseEvent} e
    * @param {HTMLDivElement} fileContainerNode The <div> containing the button
    * @param {string} fullFilePath The file's full path location
    */
  }, {
    key: "onFileContextMenu",
    value: function onFileContextMenu(e, fileContainerNode, fullFilePath) {
      // Store the file name because some buttons
      // could be available for specific file
      // extensions
      var fileName = fileContainerNode.querySelector(".file-name").textContent;
      var filePath = fileContainerNode.getAttribute("location");
      var fileExtensionRegEx = /\.([^\.]+)$/;
      var fileExtensionMatchGroup = fileName.match(fileExtensionRegEx);
      var fileExtension = null;
      if (fileExtensionMatchGroup !== null) {
        fileExtension = fileExtensionMatchGroup[1];
      }

      // Check for an existing file editor context menu
      if (FileEditorStates.currentContextMenu) {
        FileEditorStates.currentContextMenu.cleanup();
      }
      var menu = new ContextMenu(e.pageX, e.pageY);
      FileEditorStates.currentContextMenu = menu;
      var renameFileButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-input-cursor-text\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path fill-rule=\"evenodd\" d=\"M5 2a.5.5 0 0 1 .5-.5c.862 0 1.573.287 2.06.566.174.099.321.198.44.286.119-.088.266-.187.44-.286A4.165 4.165 0 0 1 10.5 1.5a.5.5 0 0 1 0 1c-.638 0-1.177.213-1.564.434a3.49 3.49 0 0 0-.436.294V7.5H9a.5.5 0 0 1 0 1h-.5v4.272c.1.08.248.187.436.294.387.221.926.434 1.564.434a.5.5 0 0 1 0 1 4.165 4.165 0 0 1-2.06-.566A4.561 4.561 0 0 1 8 13.65a4.561 4.561 0 0 1-.44.285 4.165 4.165 0 0 1-2.06.566.5.5 0 0 1 0-1c.638 0 1.177-.213 1.564-.434.188-.107.335-.214.436-.294V8.5H7a.5.5 0 0 1 0-1h.5V3.228a3.49 3.49 0 0 0-.436-.294A3.166 3.166 0 0 0 5.5 2.5.5.5 0 0 1 5 2z\"/>\n\t\t\t\t<path d=\"M10 5h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1h-4v1h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-4v1zM6 5V4H2a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4v-1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h4z\"/>\n\t\t\t</svg>\n\t\t\t<span>Rename</span>\n\t\t");
      var copyURIButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-link-45deg\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M4.715 6.542L3.343 7.914a3 3 0 1 0 4.243 4.243l1.828-1.829A3 3 0 0 0 8.586 5.5L8 6.086a1.001 1.001 0 0 0-.154.199 2 2 0 0 1 .861 3.337L6.88 11.45a2 2 0 1 1-2.83-2.83l.793-.792a4.018 4.018 0 0 1-.128-1.287z\"/>\n\t\t\t\t<path d=\"M6.586 4.672A3 3 0 0 0 7.414 9.5l.775-.776a2 2 0 0 1-.896-3.346L9.12 3.55a2 2 0 0 1 2.83 2.83l-.793.792c.112.42.155.855.128 1.287l1.372-1.372a3 3 0 0 0-4.243-4.243L6.586 4.672z\"/>\n\t\t\t</svg>\n\t\t\t<span>Copy URI</span>\n\t\t");

      /**
      * Show compile SCSS button
      */
      if (fileExtension === "scss") {
        var compileSCSSButton = menu.addButton("\n\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-braces\" viewBox=\"0 0 16 16\">\n\t\t\t\t\t<path d=\"M2.114 8.063V7.9c1.005-.102 1.497-.615 1.497-1.6V4.503c0-1.094.39-1.538 1.354-1.538h.273V2h-.376C3.25 2 2.49 2.759 2.49 4.352v1.524c0 1.094-.376 1.456-1.49 1.456v1.299c1.114 0 1.49.362 1.49 1.456v1.524c0 1.593.759 2.352 2.372 2.352h.376v-.964h-.273c-.964 0-1.354-.444-1.354-1.538V9.663c0-.984-.492-1.497-1.497-1.6zM13.886 7.9v.163c-1.005.103-1.497.616-1.497 1.6v1.798c0 1.094-.39 1.538-1.354 1.538h-.273v.964h.376c1.613 0 2.372-.759 2.372-2.352v-1.524c0-1.094.376-1.456 1.49-1.456V7.332c-1.114 0-1.49-.362-1.49-1.456V4.352C13.51 2.759 12.75 2 11.138 2h-.376v.964h.273c.964 0 1.354.444 1.354 1.538V6.3c0 .984.492 1.497 1.497 1.6z\"/>\n\t\t\t\t</svg>\n\t\t\t\t<span>Compile SCSS</span>\n\t\t\t");
        compileSCSSButton.addEventListener("click", function () {
          CompileSCSSMechanics.compileFile(filePath);
          menu.cleanup();
        });
      }
      var newFolderButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-folder-plus\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M.5 3l.04.87a1.99 1.99 0 0 0-.342 1.311l.637 7A2 2 0 0 0 2.826 14H9v-1H2.826a1 1 0 0 1-.995-.91l-.637-7A1 1 0 0 1 2.19 4h11.62a1 1 0 0 1 .996 1.09L14.54 8h1.005l.256-2.819A2 2 0 0 0 13.81 3H9.828a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 6.172 1H2.5a2 2 0 0 0-2 2zm5.672-1a1 1 0 0 1 .707.293L7.586 3H2.19c-.24 0-.47.042-.684.12L1.5 2.98a1 1 0 0 1 1-.98h3.672z\"/>\n\t\t\t\t<path d=\"M13.5 10a.5.5 0 0 1 .5.5V12h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V13h-1.5a.5.5 0 0 1 0-1H13v-1.5a.5.5 0 0 1 .5-.5z\"/>\n\t\t\t</svg>\n\t\t\t<span>New folder</span>\n\t\t");
      var newFileButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-file-earmark-plus\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M8 6.5a.5.5 0 0 1 .5.5v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 .5-.5z\"/>\n\t\t\t\t<path d=\"M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5L14 4.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5h-2z\"/>\n\t\t\t</svg>\n\t\t\t<span>New file</span>\n\t\t");
      menu.addSeparator();
      var deleteFileButton = menu.addButton("\n\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"red\" class=\"bi bi-x-octagon-fill\" viewBox=\"0 0 16 16\">\n\t\t\t\t<path d=\"M11.46.146A.5.5 0 0 0 11.107 0H4.893a.5.5 0 0 0-.353.146L.146 4.54A.5.5 0 0 0 0 4.893v6.214a.5.5 0 0 0 .146.353l4.394 4.394a.5.5 0 0 0 .353.146h6.214a.5.5 0 0 0 .353-.146l4.394-4.394a.5.5 0 0 0 .146-.353V4.893a.5.5 0 0 0-.146-.353L11.46.146zm-6.106 4.5L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z\"/>\n\t\t\t</svg>\n\t\t\t<span>Delete file</span>\n\t\t");
      renameFileButton.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
        var fileName;
        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              fileName = fileContainerNode.querySelector(".file-name").textContent;
              document.querySelector("#rename-file-path").value = fullFilePath;
              document.querySelector("#rename-file-new-name-input").value = fileName;
              RenameFileModal.showModal();
              menu.cleanup();
            case 5:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      })));
      copyURIButton.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
        var result, fullSystemFilePath, relativePathFromAppRoot, browserNavigatableURI;
        return _regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              _context5.next = 2;
              return navigator.permissions.query({
                name: "clipboard-write"
              });
            case 2:
              result = _context5.sent;
              if (!(result.state === "granted" || result.state === "prompt")) {
                _context5.next = 9;
                break;
              }
              fullSystemFilePath = fileContainerNode.getAttribute("location");
              relativePathFromAppRoot = fullSystemFilePath.replace(FileEditorStates.applicationRoot, "");
              browserNavigatableURI = relativePathFromAppRoot.replace(new RegExp(/\\/g), "/");
              _context5.next = 9;
              return navigator.clipboard.writeText("".concat(browserNavigatableURI));
            case 9:
              menu.cleanup();
            case 10:
            case "end":
              return _context5.stop();
          }
        }, _callee5);
      })));
      deleteFileButton.addEventListener("click", function () {
        DeleteFileMechanic.deleteFile(filePath, fileContainerNode);
        menu.cleanup();
      });
      newFileButton.addEventListener("click", function () {
        NewFileModal.showModal();
        menu.cleanup();
      });
      newFolderButton.addEventListener("click", function () {
        NewDirectoryModal.showModal();
        menu.cleanup();
      });

      // Render the menu
      menu.render();
    }

    /**
    * When the directory navigation back button is clicked
    */
  }, {
    key: "onBackButtonClicked",
    value: function onBackButtonClicked() {
      var currentHistory = FileEditorStates.directoryLocationHistory;
      if (this.isLoadingDirectory === false) {
        if (currentHistory.length > 0) {
          // Pop the latest (which is the current) location
          FileEditorStates.directoryLocationHistory.pop();
          if (FileEditorStates.directoryLocationHistory.length === 0) {
            this.backButton.classList.remove("is-active");
          }

          // Go to the now, new latest location
          var nextLocation = FileEditorStates.directoryLocationHistory[FileEditorStates.directoryLocationHistory.length - 1];
          if (nextLocation === undefined) {
            // The next location is the root directory
            nextLocation = FileEditorStates.rootThemeDirectory;
          }
          FileEditorStates.currentDirectory = Utils.getThemeFileRelativeLocationFromFullPath(nextLocation);
          this.loadDirectory(nextLocation);
        }
      }
    }

    /**
    * Fetches and renders directory contents
    * @param {string} directory
    */
  }, {
    key: "loadDirectory",
    value: (function () {
      var _loadDirectory = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(directory) {
        var relativePathFromThemeRoot, searchParams, endpoint, response, data, contents, directories, files, _iterator, _step, fsDirectory, _iterator2, _step2, fsFile;
        return _regeneratorRuntime().wrap(function _callee6$(_context6) {
          while (1) switch (_context6.prev = _context6.next) {
            case 0:
              if (!this.isLoadingDirectory) {
                _context6.next = 2;
                break;
              }
              return _context6.abrupt("return");
            case 2:
              // Clear the filter input
              document.querySelector("#directory-filter").value = "";

              // Fetch the relative directory to show the user and fetch from the API
              relativePathFromThemeRoot = Utils.getThemeFileRelativeLocationFromFullPath(directory);
              if (relativePathFromThemeRoot !== "") {
                document.querySelector("#directory-location-input").value = relativePathFromThemeRoot;
              } else {
                document.querySelector("#directory-location-input").value = "/";
              }

              // Switch flag
              this.isLoadingDirectory = true;
              SidebarLoadingOverlay.show();

              // Clear the existing entries
              this.directoryListingDOM.innerHTML = "";
              searchParams = new URLSearchParams();
              searchParams.append("directory-requested", directory);
              endpoint = "/uplift/theme-manager/list-directory?".concat(searchParams.toString());
              _context6.next = 13;
              return fetch(endpoint, {
                cache: "no-cache",
                credentials: "same-origin"
              });
            case 13:
              response = _context6.sent;
              _context6.next = 16;
              return Scheduler.wait(250);
            case 16:
              _context6.next = 18;
              return response.json();
            case 18:
              data = _context6.sent;
              this.isLoadingDirectory = false;
              if (data.status === 1) {
                // Set the application root from the response
                FileEditorStates.applicationRoot = data.applicationRoot;

                /** @type {{childDirectories: [], childFiles:[], directoryName: string, fullDirectoryPath: string }} */
                contents = data.fsDirectory;
                directories = contents.childDirectories;
                files = contents.childFiles;
                _iterator = _createForOfIteratorHelper(directories);
                try {
                  for (_iterator.s(); !(_step = _iterator.n()).done;) {
                    fsDirectory = _step.value;
                    this.directoryListingDOM.append(this.getDirectoryDOM(fsDirectory.directoryName, fsDirectory.fullDirectoryPath));
                  }
                } catch (err) {
                  _iterator.e(err);
                } finally {
                  _iterator.f();
                }
                _iterator2 = _createForOfIteratorHelper(files);
                try {
                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    fsFile = _step2.value;
                    this.directoryListingDOM.append(this.getFileDOM(fsFile.fileName, fsFile.fullFilePath));
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }
                SidebarLoadingOverlay.hide();
              } else if (data.status === -1) {
                alert(data.error);
              }
            case 21:
            case "end":
              return _context6.stop();
          }
        }, _callee6, this);
      }));
      function loadDirectory(_x) {
        return _loadDirectory.apply(this, arguments);
      }
      return loadDirectory;
    }()
    /**
     * @param {string} name
     * @param {string} fullPath
     * @returns {HTMLDivElement}
     */
    )
  }, {
    key: "getDirectoryDOM",
    value: function getDirectoryDOM(name, fullPath) {
      var _this2 = this;
      var template = document.createElement("div");
      template.classList.add("theme-manager-fm-entry");
      template.classList.add("theme-manager-directory-button-container");
      template.setAttribute("listing-type", "directory");
      template.setAttribute("location", fullPath);
      template.innerHTML = "\n\t\t\t<button type=\"button\">\n\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-folder-fill\" viewBox=\"0 0 16 16\">\n\t\t\t\t\t<path d=\"M9.828 3h3.982a2 2 0 0 1 1.992 2.181l-.637 7A2 2 0 0 1 13.174 14H2.826a2 2 0 0 1-1.991-1.819l-.637-7a1.99 1.99 0 0 1 .342-1.31L.5 3a2 2 0 0 1 2-2h3.672a2 2 0 0 1 1.414.586l.828.828A2 2 0 0 0 9.828 3zm-8.322.12C1.72 3.042 1.95 3 2.19 3h5.396l-.707-.707A1 1 0 0 0 6.172 2H2.5a1 1 0 0 0-1 .981l.006.139z\"/>\n\t\t\t\t</svg>\n\t\t\t\t<span class=\"directory-name item-label\">".concat(name, "</span>\n\t\t\t</button>\n\t\t");
      var button = template.querySelector("button");

      // Double click
      var lastClickTime = 0;
      button.addEventListener("click", function () {
        if (!_this2.backButton.classList.contains("is-active")) {
          _this2.backButton.classList.add("is-active");
        }
        var now = new Date().getTime();
        if (now - lastClickTime <= 350) {
          FileEditorStates.directoryLocationHistory.push(fullPath);
          FileEditorStates.currentDirectory = Utils.getThemeFileRelativeLocationFromFullPath(fullPath);
          _this2.loadDirectory(fullPath);
        }
        lastClickTime = now;
      });

      // Context menu
      button.addEventListener("contextmenu", function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this2.onDirectoryContextMenu(e, template);
      });
      return template;
    }

    /**
    * @returns {HTMLDivElement}
    */
  }, {
    key: "getFileDOM",
    value: function getFileDOM(name, fullPath) {
      var _this3 = this;
      var template = document.createElement("div");
      template.classList.add("theme-manager-fm-entry");
      template.classList.add("theme-manager-file-button-container");
      template.setAttribute("listing-type", "file");
      template.setAttribute("location", fullPath);
      template.innerHTML = "\n\t\t\t<button type=\"button\">\n\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-file-text\" viewBox=\"0 0 16 16\">\n\t\t\t\t\t<path d=\"M5 4a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1H5zm-.5 2.5A.5.5 0 0 1 5 6h6a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5zM5 8a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1H5zm0 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1H5z\"/>\n\t\t\t\t\t<path d=\"M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2zm10-1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1z\"/>\n\t\t\t\t</svg>\n\t\t\t\t<span class=\"file-name item-label\">".concat(name, "</span>\n\t\t\t</button>\n\t\t");
      var button = template.querySelector("button");

      // Double click
      var lastClickTime = 0;
      button.addEventListener("click", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7() {
        var now, currentlySelectedButton, didOpen;
        return _regeneratorRuntime().wrap(function _callee7$(_context7) {
          while (1) switch (_context7.prev = _context7.next) {
            case 0:
              now = new Date().getTime();
              if (!(now - lastClickTime <= 350)) {
                _context7.next = 9;
                break;
              }
              // Open the file editor for this file
              // If there is a currently selected button, deselect it
              currentlySelectedButton = document.querySelector(".fm-editor-selected-file-button");
              if (currentlySelectedButton) {
                currentlySelectedButton.classList.remove("fm-editor-selected-file-button");
              }
              button.classList.add("fm-editor-selected-file-button");
              _context7.next = 7;
              return FileEditorWrapper.openFile(fullPath, name);
            case 7:
              didOpen = _context7.sent;
              if (!didOpen) {
                button.classList.remove("fm-editor-selected-file-button");
              }
            case 9:
              lastClickTime = now;
            case 10:
            case "end":
              return _context7.stop();
          }
        }, _callee7);
      })));

      // Context menu
      button.addEventListener("contextmenu", function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this3.onFileContextMenu(e, template, fullPath);
      });
      return template;
    }

    /**
    * Filters currently loaded sidebar items by text
    * @param {string} text
    */
  }, {
    key: "filterByText",
    value: function filterByText(text) {
      text = text.toLowerCase();
      var items = document.querySelectorAll(".theme-manager-fm-entry");
      var _iterator3 = _createForOfIteratorHelper(items),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var item = _step3.value;
          var name = item.querySelector(".item-label").textContent.trim().toLowerCase();
          if (text !== "") {
            if (name.includes(text)) {
              item.style.display = "inline";
            } else {
              item.style.display = "none";
            }
          } else {
            item.style.display = "inline";
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }
  }]);
}();
export default new SidebarFileLoader();