function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ArticleCategoryPageDataLabel from "./components/ArticleCategoryPageDataLabel.js";
import ArticleCategoryRow from "./components/ArticleCategoryRow.js";
import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";

/**
 * Keeps track of the selected article categories
 */
var ArticleCategoryManager = /*#__PURE__*/function () {
  function ArticleCategoryManager() {
    _classCallCheck(this, ArticleCategoryManager);
    /** @type {number[]} */
    _defineProperty(this, "selectedArticleCategories", []);
    _defineProperty(this, "noSelectionMessageContainer", document.querySelector("#no-article-category-message"));
    _defineProperty(this, "labelsContainer", document.querySelector("#article-categories-labels"));
  }
  return _createClass(ArticleCategoryManager, [{
    key: "refreshEditorDisplayOfCategories",
    value:
    /**
     * Refreshes the labels on the Page Data tab of the editor, or shows the "no categories" message.
     */
    function refreshEditorDisplayOfCategories() {
      if (this.selectedArticleCategories.length === 0) {
        this.noSelectionMessageContainer.style.display = null;
        this.labelsContainer.innerHTML = "";
        ArticleCategoryPageDataLabel.clearAll();
      } else {
        this.noSelectionMessageContainer.style.display = "none";
      }
    }

    /**
     * Stores a category ID as having been selected
     * @param {int} categoryID
     */
  }, {
    key: "addCategoryToSelected",
    value: function addCategoryToSelected(categoryID) {
      if (this.selectedArticleCategories.indexOf(categoryID) === -1) {
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
        var categoryName = ArticleCategoryRow.getByArticleCategoryID(categoryID).articleCategoryName;
        new ArticleCategoryPageDataLabel(categoryID, categoryName);
        this.selectedArticleCategories.push(categoryID);
        this.refreshEditorDisplayOfCategories();
      }
    }

    /**
     * Deselects an article category
     * @param categoryID
     */
  }, {
    key: "removeCategoryFromSelected",
    value: function removeCategoryFromSelected(categoryID) {
      var index = this.selectedArticleCategories.indexOf(categoryID);
      if (index !== -1) {
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
        this.selectedArticleCategories.splice(index, 1);
        this.refreshEditorDisplayOfCategories();
        ArticleCategoryPageDataLabel.removeRowByID(categoryID);
      }
    }

    /**
     * Clears the current category selection
     */
  }, {
    key: "clearSelectedCategories",
    value: function clearSelectedCategories() {
      this.selectedArticleCategories = [];
      this.refreshEditorDisplayOfCategories();
    }
  }]);
}();
export default new ArticleCategoryManager();