function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import AceEditorExtension from "../../AceEditorExtension.js";
import PageEditorStates from "../PageEditorStates.js";
import ContentChangedHandler from "../../ContentChangedHandler.js";
import DOMHelper from "../../DOMHelper.js";

/**
 * Represents a single instance of an individual section editor component for a page's body content.
 */
export var PageContentSectionEditor = /*#__PURE__*/function () {
  /**
   * @param {{id: number, creationTimestamp: number, pageLayoutSectionDefinitionId: number, sectionName: string}} pageLayoutSectionDto
   * @param {{id: number|null, pageId: number, sectionName: string, content: string | null}|null} pageContentSectionDto This can be null
   */
  function PageContentSectionEditor(pageLayoutSectionDto, pageContentSectionDto) {
    _classCallCheck(this, PageContentSectionEditor);
    /**
     * The HTML element this component is represented by
     * @type {HTMLDivElement}
     */
    _defineProperty(this, "dom", void 0);
    /**
     * The page layout section objects that this page content section should reflect. Can't be null
     * @type {{id: number, pageLayoutSectionDefinitionId: number, sectionName: string, creationTimestamp: number}}
     */
    _defineProperty(this, "pageLayoutSectionDto", void 0);
    /**
     * The object that represents this individual section for this particular page. Can be null
     * if it has never been saved yet.
     * @type {{id: number, pageId: number, sectionName: string, content: string} | null}
     */
    _defineProperty(this, "pageContentSectionDto", void 0);
    /**
     * The instance of AceEditorExtension that the editor for this component is using
     * @type {AceEditorExtension}
     */
    _defineProperty(this, "aceEditorExtension", void 0);
    this.pageLayoutSectionDto = pageLayoutSectionDto;
    this.pageContentSectionDto = pageContentSectionDto;
    this.constructor.cache.push(this);

    // Create a PageContentSection dto if the one we got was null. Just leave the id null for now,
    // as the page saving logic will populate it once the PageContentSection is saved and created
    // on the backend
    if (pageContentSectionDto === null) {
      this.pageContentSectionDto = {
        id: null,
        pageId: PageEditorStates.currentPageID,
        sectionName: this.pageLayoutSectionDto.sectionName,
        content: ""
      };
    }
  }
  return _createClass(PageContentSectionEditor, [{
    key: "build",
    value: function build() {
      var _this$pageContentSect,
        _this$pageContentSect2,
        _this = this;
      var template = document.createElement("div");
      template.classList.add("page-content-section-editor-component");
      template.innerHTML = "\n\t\t\t<div class=\"title-container\">\n\t\t\t\t<strong class=\"me-2\">Section: </strong><span>".concat(this.pageLayoutSectionDto.sectionName, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"editor-container\">\n\t\t\t\t<div class=\"ace-editor-container\" style=\"height:500px\"></div>\n\t\t\t</div>\n\t\t");
      this.aceEditorExtension = new AceEditorExtension(template.querySelector(".ace-editor-container"), "html");
      this.aceEditorExtension.loadExtensions();
      this.aceEditorExtension.ace.session.setValue((_this$pageContentSect = (_this$pageContentSect2 = this.pageContentSectionDto) === null || _this$pageContentSect2 === void 0 ? void 0 : _this$pageContentSect2.content) !== null && _this$pageContentSect !== void 0 ? _this$pageContentSect : "");

      // Connect a change event to trigger the unsaved changes marker
      this.aceEditorExtension.ace.on("change", function () {
        if (!PageEditorStates.isLoadingPage) {
          ContentChangedHandler.showUnsavedChangeIdentifier(DOMHelper.getAllPageEditorTabs().body);
          PageEditorStates.markAsHavingUnsavedChanges(false);
          _this.pageContentSectionDto.content = _this.aceEditorExtension.ace.session.getValue();
        }
      });

      // When focused, set it as the current editor in the page states. This
      // tells the system where to insert objects selected from shortcodes I guess
      this.aceEditorExtension.ace.on("focus", function () {
        PageEditorStates.currentEditor = _this.aceEditorExtension;
      });
      this.dom = template;
      return this;
    }
  }, {
    key: "renderInto",
    value: function renderInto(container) {
      container.append(this.dom);
      this.aceEditorExtension.ace.resize(true);
    }
  }], [{
    key: "clearAll",
    value:
    /**
     * Clears all the currently rendered PageContentSectionEditor
     */
    function clearAll() {
      var _iterator = _createForOfIteratorHelper(PageContentSectionEditor.cache),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var sectionEditor = _step.value;
          sectionEditor.dom.remove();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      PageContentSectionEditor.cache = [];
    }
  }]);
}();
/**
 * A cache of currently rendered PageContentSectionEditor
 * @type {PageContentSectionEditor[]}
 */
_defineProperty(PageContentSectionEditor, "cache", []);