function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import BlogReelModal from "../modals/BlogReelModal.js";
var BlogReelShortcodeButton = /*#__PURE__*/function () {
  function BlogReelShortcodeButton() {
    var _this = this;
    _classCallCheck(this, BlogReelShortcodeButton);
    if (PageEditorStates.viewType !== "REVISION") {
      this.button = document.querySelector("#article-reel-shortcode-button");
      this.button.addEventListener("click", function () {
        _this.onButtonClicked();
      });
    }
  }

  /**
  * When one of the inner buttons inside the main shortcode
  * button is clicked
  */
  return _createClass(BlogReelShortcodeButton, [{
    key: "onButtonClicked",
    value: function onButtonClicked() {
      BlogReelModal.showModal();
    }

    /**
    * Usually called from the modal's form when it's submitted.
    * Will inject the shortcode into the current editor
    * @param {int} numArticlesPerPage
    * @param {int} numColumns
    * @param {string[]} includedCategoryIDs
    * @param {string[]} excludedCategoryIDs
    */
  }, {
    key: "injectShortcode",
    value: function injectShortcode(numArticlesPerPage, numColumns, includedCategoryIDs, excludedCategoryIDs) {
      includedCategoryIDs = JSON.stringify(includedCategoryIDs);
      excludedCategoryIDs = JSON.stringify(excludedCategoryIDs);
      var shortcodeText = "{{ get-articles articles-per-page=\"".concat(numArticlesPerPage, "\" columns=\"").concat(numColumns, "\" included-categories=\"").concat(includedCategoryIDs, "\" excluded-categories=\"").concat(excludedCategoryIDs, "\" }}");
      EditorWrapper.insertTextAtCursor(shortcodeText);
      BlogReelModal.hideModal();
      EditorWrapper.focusEditor();
    }
  }]);
}();
export default new BlogReelShortcodeButton();