function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import RecentArticlesModal from "../modals/RecentArticlesModal.js";
var RecentArticlesShortcodeButton = /*#__PURE__*/function () {
  function RecentArticlesShortcodeButton() {
    var _this = this;
    _classCallCheck(this, RecentArticlesShortcodeButton);
    if (PageEditorStates.viewType !== "REVISION") {
      this.button = document.querySelector("#recent-articles-shortcode-button");
      this.button.addEventListener("click", function () {
        _this.onButtonClicked();
      });
    }
  }

  /**
  * When one of the inner buttons inside the main shortcode
  * button is clicked
  */
  return _createClass(RecentArticlesShortcodeButton, [{
    key: "onButtonClicked",
    value: function onButtonClicked() {
      RecentArticlesModal.showModal();
    }

    /**
    * Usually called from the modal's form when it's submitted.
    * Will inject the shortcode into the current editor
    * @param {int} numRecentArticles
    * @param {int} numColumns
    * @param {int[]} includedArticleCategories
    * @param {string|null} autofillArticles "on" or null
    */
  }, {
    key: "injectShortcode",
    value: function injectShortcode(numRecentArticles, numColumns, includedArticleCategories, autofillArticles) {
      includedArticleCategories = JSON.stringify(includedArticleCategories);
      autofillArticles = autofillArticles === "on" ? 1 : 0;
      var shortcodeText = "{{ get-recent-articles num-articles=\"".concat(numRecentArticles, "\" columns=\"").concat(numColumns, "\" included-article-categories=\"").concat(includedArticleCategories, "\" autofill=\"").concat(autofillArticles, "\" }}");
      EditorWrapper.insertTextAtCursor(shortcodeText);
      RecentArticlesModal.hideModal();
      EditorWrapper.focusEditor();
    }
  }]);
}();
export default new RecentArticlesShortcodeButton();