function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import RecentProjectsModal from "../modals/RecentProjectsModal.js";
var RecentProjectsShortcodeButton = /*#__PURE__*/function () {
  function RecentProjectsShortcodeButton() {
    var _this = this;
    _classCallCheck(this, RecentProjectsShortcodeButton);
    if (PageEditorStates.viewingState !== "") {
      this.button = document.querySelector("#recent-projects-shortcode-button");
      this.button.addEventListener("click", function () {
        _this.onButtonClicked();
      });
    }
  }

  /**
  * When one of the inner buttons inside of the main shortcode
  * button is clicked
  * @param {Button} button HTML DOMNode
  */
  return _createClass(RecentProjectsShortcodeButton, [{
    key: "onButtonClicked",
    value: function onButtonClicked(button) {
      RecentProjectsModal.showModal();
    }

    /**
    * Usually called from the modal's form when it's submitted.
    * Will inject the shortcode into the current editor
    * @param {int} numProjectsPerPage
    * @param {int} numColumns
    * @param {string[]} includedProjectTags
    * @param {string|null} autofillProjects "on" or null
    */
  }, {
    key: "injectShortcode",
    value: function injectShortcode(numProjectsPerPage, numColumns, includedProjectTags, autofillProjects) {
      includedProjectTags = JSON.stringify(includedProjectTags);
      autofillProjects = autofillProjects === "on" ? 1 : 0;
      var shortcodeText = "{{ get-recent-projects num-projects=\"".concat(numProjectsPerPage, "\" columns=\"").concat(numColumns, "\" included-project-tags=\"").concat(includedProjectTags, "\" autofill=\"").concat(autofillProjects, "\" }}");
      EditorWrapper.insertTextAtCursor(shortcodeText);
      RecentProjectsModal.hideModal();
      EditorWrapper.focusEditor();
    }
  }]);
}();
export default new RecentProjectsShortcodeButton();