function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Breadcrumb = /*#__PURE__*/function () {
  function Breadcrumb() {
    _classCallCheck(this, Breadcrumb);
    _defineProperty(this, "dom", null);
    _defineProperty(this, "labelInput", null);
    _defineProperty(this, "uriInput", null);
    this.id = Breadcrumb.nextID++;
    this.dom = this.getDOM();
    Breadcrumb.container.append(this.dom);
    Breadcrumb.cache.push(this);
  }
  return _createClass(Breadcrumb, [{
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("external-importer-breadcrumb-component");
      template.innerHTML = "\n\t\t\t<div class=\"label-container\">\n\t\t\t\t<label>Crumb label</label>\n\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-input-cursor-text\"></i></span>\n\t\t\t\t\t<input type=\"text\" class=\"form-control label-input\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"uri-container\">\n\t\t\t\t<label>Crumb URI</label>\n\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-input-cursor-text\"></i></span>\n\t\t\t\t\t<input type=\"text\" class=\"form-control uri-input\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"buttons-container\">\n\t\t\t\t<button type=\"button\" class=\"prefill-crumb-button btn btn-primary\">\n\t\t\t\t\t<i class=\"bi bi-filter-square-fill\"></i>\n\t\t\t\t\t<span>Prefill</span>\n\t\t\t\t</button>\n\t\t\t\t<button type=\"button\" class=\"delete-crumb-button btn btn-danger\">\n\t\t\t\t\t<i class=\"bi bi-trash-fill\"></i>\n\t\t\t\t\t<span>Remove</span>\n\t\t\t\t</button>\n\t\t\t</div>\n\t\t";
      this.labelInput = template.querySelector(".label-input");
      this.uriInput = template.querySelector(".uri-input");
      var deleteButton = template.querySelector(".delete-crumb-button");
      deleteButton.addEventListener("click", function () {
        _this.onDeleteButtonClicked();
      });
      var prefillButton = template.querySelector(".prefill-crumb-button");
      prefillButton.addEventListener("click", function () {
        _this.onPrefillCrumbButtonClicked();
      });
      return template;
    }
  }, {
    key: "onDeleteButtonClicked",
    value: function onDeleteButtonClicked() {
      Breadcrumb.removeFromCache(this);
      this.dom.remove();
    }
  }, {
    key: "onPrefillCrumbButtonClicked",
    value: function onPrefillCrumbButtonClicked() {
      this.uriInput.value = document.querySelector("#page-route-input").value;
      this.labelInput.value = document.querySelector("#page-name-input").value;
    }
  }], [{
    key: "removeFromCache",
    value:
    /**
     *
     * @param {Breadcrumb} crumb
     */
    function removeFromCache(crumb) {
      for (var crumbIndex in Breadcrumb.cache) {
        var cacheCrumb = Breadcrumb.cache[crumbIndex];
        if (cacheCrumb.id === crumb.id) {
          Breadcrumb.cache.splice(parseInt(crumbIndex), 1);
          break;
        }
      }
    }
  }]);
}();
/**@type {Breadcrumb[]} */
_defineProperty(Breadcrumb, "cache", []);
_defineProperty(Breadcrumb, "container", document.querySelector("#breadcrumbs-components-container"));
_defineProperty(Breadcrumb, "nextID", 0);
export default Breadcrumb;