function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ImageGallery from "../ImageGallery.js";
var GalleryRow = /*#__PURE__*/function () {
  function GalleryRow(id, name, numImagesInGallery, creationTimestamp) {
    _classCallCheck(this, GalleryRow);
    this.id = id;
    this.name = name;
    this.numImagesInGallery = numImagesInGallery;
    this.creationTimestamp = creationTimestamp;
    this.dom = this.getDOM();

    // Add it to the DOM
    GalleryRow.container.append(this.dom);
    GalleryRow.rows.push(this);
  }

  /**
   * @return {HTMLDivElement}
   */
  return _createClass(GalleryRow, [{
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      var creationDateTime = new Date(parseInt(this.creationTimestamp) * 1000);
      template.classList.add("gallery-row-item");
      template.classList.add("gallery-table-columns");
      template.innerHTML = "\n\t\t\t<div class=\"icon\">\n\t\t\t\t<i class=\"bi bi-folder-fill\"></i>\n\t\t\t</div>\n\t\t\t<div class=\"name\">\n\t\t\t\t<span>".concat(this.name, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"image-member-count\">\n\t\t\t\t<span>").concat(this.numImagesInGallery, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"creation-time\">\n\t\t\t\t<span>").concat(creationDateTime.toLocaleDateString(), "</span>\n\t\t\t</div>\n\t\t");
      template.addEventListener("click", function () {
        var manageGalleryModal = ImageGallery.manageGalleryModal;
        manageGalleryModal.currentGalleryID = _this.id;
        manageGalleryModal.titleContainer.textContent = _this.name;
        manageGalleryModal.showModal();
        manageGalleryModal.loadMembers(_this.id);
      });
      return template;
    }
  }], [{
    key: "clearRows",
    value: function clearRows() {
      var _iterator = _createForOfIteratorHelper(GalleryRow.rows),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var row = _step.value;
          row.dom.remove();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      GalleryRow.rows = [];
    }

    /**
     * @param {int} galleryID}
     * @return {GalleryRow}
     */
  }, {
    key: "getByGalleryID",
    value: function getByGalleryID(galleryID) {
      var _iterator2 = _createForOfIteratorHelper(GalleryRow.rows),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var row = _step2.value;
          if (galleryID === row.id) {
            return row;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return null;
    }
  }]);
}();
_defineProperty(GalleryRow, "container", document.querySelector("#gallery-rows-container"));
_defineProperty(GalleryRow, "rows", []);
export default GalleryRow;