function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ImageManagerState from "./ImageManagerState.js";
import DirectoryImagesFetcher from "./DirectoryImagesFetcher.js";
var BreadcrumbHandler = /*#__PURE__*/function () {
  /**
   * @param {ImageManager} imageManager
   */
  function BreadcrumbHandler(imageManager) {
    _classCallCheck(this, BreadcrumbHandler);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    /**
     * @type {HTMLElement}
     */
    _defineProperty(this, "container", void 0);
    this.imageManager = imageManager;
    this.container = imageManager.getBreadcrumbsContainer();
    this.currentDOMs = [];
  }

  /**
   * Fetches a location crumb
   * @param {string} crumbLabel
   * @param {string} fullDirectoryPath
   */
  return _createClass(BreadcrumbHandler, [{
    key: "getCrumbDOM",
    value: function getCrumbDOM(crumbLabel, fullDirectoryPath) {
      var _this = this;
      var template = document.createElement("im-location-button");
      template.setAttribute("filesystem-path", fullDirectoryPath);
      template.innerHTML = "\n\t\t\t<span class=\"folder-name\">".concat(crumbLabel, "</span>\n\t\t");
      template.addEventListener("click", function () {
        var imFetcher = _this.imageManager.directoryImagesFetcher;
        imFetcher.setDirectory(fullDirectoryPath);
        imFetcher.fetchAndRender();
      });
      this.currentDOMs.push(template);
      return template;
    }

    /**
     * Breaks the current directory from the image manager state into an array of
     * crumb paths.
     * @return {array}
     */
  }, {
    key: "getCurrentDirectoryAsArrayPath",
    value: function getCurrentDirectoryAsArrayPath() {
      var baseDirectory = this.imageManager.imageManagerState.baseImagesDirectory;
      var baseNameRegex = /[\/\\]([^\/\\]+?)$/;
      var currentDirectoryPath = this.imageManager.imageManagerState.currentDirectory.replace(baseDirectory, "");
      var loops = 0;
      var locations = [];
      while (currentDirectoryPath !== "" && loops < 20) {
        var baseNameMatches = currentDirectoryPath.match(baseNameRegex);

        // Handle failure. Usually happens in local environments due to the C: or HDD path in general
        if (baseNameMatches === null) {
          console.warn("Directory regex failed. Finally directory processed that caused the match failure is ".concat(currentDirectoryPath));
          break;
        }
        var dirBaseName = baseNameMatches[1];
        locations.push({
          "fullDirectory": "".concat(baseDirectory).concat(currentDirectoryPath),
          "baseName": dirBaseName
        });
        currentDirectoryPath = currentDirectoryPath.replace(/[\/\\][^\/\\]+?$/, "");
        ++loops;
      }
      locations.push({
        "fullDirectory": baseDirectory,
        "baseName": baseDirectory.match(baseNameRegex)[1]
      });
      locations.reverse();
      return locations;
    }

    /**
     * Renders a single crumb dom
     */
  }, {
    key: "render",
    value: function render(baseName, fullPath) {
      var dom = this.getCrumbDOM(baseName, fullPath);
      this.container.append(dom);
    }

    /**
     * Rebuilds the breadcrumbs to match the current location
     */
  }, {
    key: "refreshLocation",
    value: function refreshLocation() {
      this.container.innerHTML = "";
      var directoryPaths = this.getCurrentDirectoryAsArrayPath();
      var _iterator = _createForOfIteratorHelper(directoryPaths),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var pathInfo = _step.value;
          this.render(pathInfo.baseName, pathInfo.fullDirectory);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }]);
}();
export default BreadcrumbHandler;