function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ImageManagerState = /*#__PURE__*/function () {
  function ImageManagerState(imageManager) {
    var _this = this;
    _classCallCheck(this, ImageManagerState);
    _defineProperty(this, "imageManager", null);
    this.imageManager = imageManager;
    this.IMAGE_MODES = {
      NONE: 0,
      // For when no insert or select button should appear
      INSERT: 1,
      SELECT: 2
    };
    this.imageMode = this.IMAGE_MODES.INSERT;
    this.baseImagesDirectory = null;
    this.currentDirectory = null;

    /**
     * Flag to stop the "upload window" appearing when the user is dragging a ImageManager component.
     * @type {boolean}
     */
    this.isDraggingComponent = false;

    /**
     * The currently dragged image component
     * @type {ImageComponent}
     */
    this.currentlyDraggedImageComponent = null;

    /**
     * The currently dragged folder component
     * @type {SidebarFolderComponent}
     */
    this.currentlyDraggedFolderComponent = null;

    /**
     * This is appended to all thumb images when images are loaded into
     * the image manager. Changing this string will force all of them
     * to cache-refresh and is usually done after an image is modified
     * to make sure the newest version of the thumb image is shown to the user in
     * the sidebar of the image manager.
     * @type {string}
     */
    this.currentImageCacheRandomString = String(Math.random());

    // Flag reset for dragging an image component
    window.addEventListener("drop", function (e) {
      if (_this.isDraggingComponent === true) {
        // Reset this flag
        _this.isDraggingComponent = false;
      }
    });
  }

  /**
   * Sets the mode in which a select selection is handle.
   * @param {int} imageMode
   */
  return _createClass(ImageManagerState, [{
    key: "setImageMode",
    value: function setImageMode(imageMode) {
      this.imageMode = imageMode;
    }
  }]);
}();
export default ImageManagerState;