function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var MetaDataPane = /*#__PURE__*/function () {
  /**
   * @param {ImageManager} imageManager
   */
  function MetaDataPane(imageManager) {
    _classCallCheck(this, MetaDataPane);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    this.imageManager = imageManager;
    this.pane = this.imageManager.container.querySelector(".img-meta-column");
    this.preview = this.imageManager.container.querySelector(".im-manager-preview");
    this.imageDataContainer = this.imageManager.container.querySelector(".img-info-container");
  }

  /**
   * @param {string} src The image's source URI
   */
  return _createClass(MetaDataPane, [{
    key: "showPreview",
    value: function showPreview(src) {
      this.preview.style.display = "block";
      this.preview.setAttribute("src", src + "?cache=".concat(this.imageManager.imageManagerState.currentImageCacheRandomString));
    }

    /**
     * @param {string} fileSize
     * @param {string} fileType
     * @param {?int} imageWidth
     * @param {?int} imageHeight
     */
  }, {
    key: "showImageData",
    value: function showImageData(fileSize, fileType, imageWidth, imageHeight) {
      this.imageDataContainer.style.display = "block";
      document.querySelector("#im-file-size").textContent = fileSize;
      document.querySelector("#im-file-type").textContent = fileType;

      // For example, SVGs do not have set widths and heights
      if (imageWidth && imageHeight) {
        document.querySelector("#im-dimensions").parentElement.style.display = "block";
        document.querySelector("#im-dimensions").textContent = "".concat(imageWidth, "x").concat(imageHeight);
      } else {
        document.querySelector("#im-dimensions").parentElement.style.display = "none";
      }
    }

    /**
     * Shows the visual preview of an image
     */
  }, {
    key: "hidePreview",
    value: function hidePreview() {
      this.preview.style.display = "none";
    }

    /**
     * Hides the textual metadata about a selected image
     */
  }, {
    key: "hideImageData",
    value: function hideImageData() {
      this.imageDataContainer.style.display = "none";
    }
  }]);
}();
export default MetaDataPane;