function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import CropWindow from "./windows/CropWindow.js";
import CloneWindow from "./windows/CloneWindow.js";
import ResizeWindow from "./windows/ResizeWindow.js";
import MainWindow from "./windows/MainWindow.js";

/**
 * Responsible for managing the current modal window visibility and swapping between them.
 */
var WindowManager = /*#__PURE__*/function () {
  /**
   * @param {ImageManager} imageManager
   */
  function WindowManager(imageManager) {
    var _this = this;
    _classCallCheck(this, WindowManager);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    /**
     * @type {CloneWindow}
     */
    _defineProperty(this, "cloneWindow", void 0);
    /**
     * @type {CropWindow}
     */
    _defineProperty(this, "cropWindow", void 0);
    /**
     * @type {MainWindow}
     */
    _defineProperty(this, "mainWindow", void 0);
    /**
     * @type {ResizeWindow}
     */
    _defineProperty(this, "resizeWindow", void 0);
    this.imageManager = imageManager;
    this.container = imageManager.container;

    /** @type {?HTMLElement} */
    this.currentWindow = null;

    /** @type {null|number} */
    this.currentWindowNumber = null;

    /** @type {?HTMLElement} */
    this.lastMouseDownElement = null;
    this.cloneWindow = new CloneWindow(imageManager);
    this.cropWindow = new CropWindow(imageManager);
    this.mainWindow = new MainWindow(imageManager);
    this.resizeWindow = new ResizeWindow(imageManager);

    /**
     * The index of each window should correspond to the static WINDOWS property
     */
    this.windows = [this.imageManager.container.querySelector("image-manager-window"), this.imageManager.container.querySelector(".im-resize-window"), this.imageManager.container.querySelector(".im-crop-window"), this.imageManager.container.querySelector(".im-clone-window"), this.imageManager.container.querySelector(".im-quick-gallery-menu")];
    this.container.addEventListener("mousedown", function (e) {
      _this.lastMouseDownElement = e.target;
    });
    this.container.addEventListener("mouseup", function (e) {
      if (e.target === _this.container) {
        if (_this.lastMouseDownElement === e.target) {
          if (_this.currentWindow === _this.windows[WindowManager.WINDOWS.MAIN]) {
            _this.closeImageManager();
          } else {
            _this.show(WindowManager.WINDOWS.MAIN);
          }
        }
      }
    });
  }

  /**
   * Transitions to the provided window enum
   * @param {number} windowID
   */
  return _createClass(WindowManager, [{
    key: "show",
    value: function show(windowID) {
      var _this2 = this;
      /** @type {HTMLElement} */
      var element = this.windows[windowID];

      // Check if the container is visible
      if (this.container.style.display === "none") {
        this.container.style.display = "block";
      }
      if (this.currentWindow) {
        this.currentWindow.style.display = "none";
      } else {
        // There is no current window, so the image manager is being open for the first time
        this.imageManager.imagesChosen = new Promise(function (resolve) {
          // Leak the resolver out of scope, so we can call it from other functions
          _this2.imageManager.imagesChosenPromiseResolveFunction = resolve;
        });
      }
      element.style.display = "flex";
      this.currentWindow = element;
      this.currentWindowNumber = windowID;
    }

    /**
     * Closes the entire image manager
     */
  }, {
    key: "closeImageManager",
    value: function closeImageManager() {
      if (this.currentWindow) {
        this.currentWindow.style.display = "none";
        this.currentWindow = null;
        this.currentWindowNumber = null;
        if (this.container.style.display !== "none") {
          this.container.style.display = "none";

          // Clear promise stuff, resolve the promise if it still exists
          if (this.imageManager.imagesChosen !== null) {
            // Resolve without a selection
            this.imageManager.imagesChosenPromiseResolveFunction(null);
          }
          this.imageManager.imagesChosen = null;
          this.imageManager.imagesChosenPromiseResolveFunction = null;
        }
      }
    }
  }]);
}();
/**
 *
 * @type {{RESIZE: number, MAIN: number, CROP: number, CLONE: number, QUICK_GALLERY: number}}
 */
_defineProperty(WindowManager, "WINDOWS", {
  MAIN: 0,
  RESIZE: 1,
  CROP: 2,
  CLONE: 3,
  QUICK_GALLERY: 4
});
export default WindowManager;