function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(typeof e + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import Endpoints from "../../Endpoints.js";
import WindowManager from "../WindowManager.js";
import DirectoryImagesFetcher from "../DirectoryImagesFetcher.js";
import SelectionListener from "../SelectionListener.js";
import ImageManagerState from "../ImageManagerState.js";
import MetaDataPane from "../MetaDataPane.js";
import MainWindow from "./MainWindow.js";
var ResizeWindow = /*#__PURE__*/function () {
  function ResizeWindow(imageManager) {
    var _this = this;
    _classCallCheck(this, ResizeWindow);
    // In percent
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    /**
     * @type {HTMLElement}
     */
    _defineProperty(this, "window", void 0);
    this.imageManager = imageManager;
    this.window = this.imageManager.container.querySelector(".im-resize-window");
    this.dismissButton = this.window.querySelector(".im-modal-dismiss-button");
    this.form = this.window.querySelector(".im-resize-fields");
    this.formSubmitButton = this.window.querySelector(".im-resize-form-submit-button");
    this.previewsContainer = this.window.querySelector(".im-resize-preview-images-container");
    this.spinnerContainer = this.window.querySelector(".resize-modal-loading-spinner");
    this.constrainCheckbox = this.window.querySelector(".im-resize-constrained-checkbox");
    this.imageFilePathInput = this.window.querySelector("[name=\"image-file-path\"]");
    this.oWidthInput = this.window.querySelector("[name=\"original-width\"]");
    this.widthInput = this.window.querySelector("[name=\"width\"]");
    this.oHeightInput = this.window.querySelector("[name=\"original-height\"]");
    this.heightInput = this.window.querySelector("[name=\"height\"]");
    this.leftPreviewShiftbutton = this.window.querySelector(".im-resize-scroll-left-button");
    this.rightPreviewShiftbutton = this.window.querySelector(".im-resize-scroll-right-button");

    /** @type {ImageComponent[]} Because not all images in the current selection are valid resizables */
    this.queuedImageComponents = [];

    /** @type {int} */
    this.currentPreviewIndex = 0;

    /** @type {boolean} Flag for when the form is submitting and being processed */
    this.isProcessing = false;

    /** @type {HTMLElement[]} */
    this.currentPreviews = [];
    this.heightInput.addEventListener("input", function () {
      _this.onSizeInputChanged(_this.heightInput);
    });
    this.widthInput.addEventListener("input", function () {
      _this.onSizeInputChanged(_this.widthInput);
    });
    this.formSubmitButton.addEventListener("click", function () {
      _this.onSubmit();
    });
    this.form.addEventListener("submit", function (e) {
      e.preventDefault();
      _this.onSubmit();
    });
    this.dismissButton.addEventListener("click", function () {
      if (!_this.isProcessing) {
        _this.imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);
      }
    });
    this.leftPreviewShiftbutton.addEventListener("click", function (e) {
      _this.shiftPreview("left");
    });
    this.rightPreviewShiftbutton.addEventListener("click", function (e) {
      _this.shiftPreview("right");
    });
  }

  /**
   * Gather valid resizable images
   */
  return _createClass(ResizeWindow, [{
    key: "getAcceptableImagesFromSelection",
    value: function getAcceptableImagesFromSelection() {
      this.queuedImageComponents = [];
      var _iterator = _createForOfIteratorHelper(this.imageManager.selectionListener.currentImageComponentSelection),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var component = _step.value;
          if (component.fileExtension !== "svg") {
            this.queuedImageComponents.push(component);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Shifts the preview a direction
     */
  }, {
    key: "shiftPreview",
    value: function shiftPreview(direction) {
      if (direction === "left") {
        if (this.currentPreviewIndex > 0) {
          --this.currentPreviewIndex;
        }
      } else if (direction === "right") {
        if (this.currentPreviewIndex < this.queuedImageComponents.length - 1) {
          ++this.currentPreviewIndex;
        }
      }
      this.window.querySelector(".im-resize-current-index").textContent = String(this.currentPreviewIndex + 1);
      this.previewsContainer.style.marginLeft = "-".concat(this.currentPreviewIndex * ResizeWindow.previewMarginShift, "%");
    }

    /**
     * When the resize form is submitted
     * @return {string[]} Of errors
     */
  }, {
    key: "onSubmit",
    value: (function () {
      var _onSubmit = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var _this2 = this;
        var currentQueueNumber, finishedNumber, errors, _iterator2, _step2, _loop;
        return _regeneratorRuntime().wrap(function _callee2$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (!this.isProcessing) {
                _context3.next = 2;
                break;
              }
              return _context3.abrupt("return");
            case 2:
              currentQueueNumber = this.spinnerContainer.querySelector(".im-finished-resize-number");
              this.isProcessing = true;
              this.spinnerContainer.querySelector(".im-resize-in-queue-upload-number").textContent = String(this.queuedImageComponents.length);
              currentQueueNumber.textContent = "0";
              this.spinnerContainer.style.display = "flex";
              finishedNumber = 0;
              errors = [];
              _iterator2 = _createForOfIteratorHelper(this.queuedImageComponents);
              _context3.prev = 10;
              _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
                var imageComponent;
                return _regeneratorRuntime().wrap(function _loop$(_context2) {
                  while (1) switch (_context2.prev = _context2.next) {
                    case 0:
                      imageComponent = _step2.value;
                      _context2.next = 3;
                      return new Promise(/*#__PURE__*/function () {
                        var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(resolve) {
                          var fData, aspectRatio, widthForImage, heightForImage, response, data;
                          return _regeneratorRuntime().wrap(function _callee$(_context) {
                            while (1) switch (_context.prev = _context.next) {
                              case 0:
                                fData = new FormData();
                                aspectRatio = parseInt(imageComponent.imageWidth) / parseInt(imageComponent.imageHeight);
                                widthForImage = parseInt(_this2.widthInput.value);
                                heightForImage = parseInt(_this2.heightInput.value);
                                if (!(isNaN(heightForImage) && isNaN(widthForImage))) {
                                  _context.next = 9;
                                  break;
                                }
                                errors.push("".concat(imageComponent.fileName, ": Both input values cannot be invalid numbers or blank."));
                                return _context.abrupt("return", resolve());
                              case 9:
                                if (isNaN(widthForImage) && !isNaN(heightForImage)) {
                                  // Use the height to get the width
                                  widthForImage = heightForImage / aspectRatio;
                                } else if (isNaN(heightForImage) && !isNaN(widthForImage)) {
                                  // Use the width to get the height for the image
                                  heightForImage = aspectRatio * widthForImage;
                                }
                              case 10:
                                fData.set("width", String(widthForImage));
                                fData.set("height", String(heightForImage));
                                fData.set("image-file-path", imageComponent.fullFilePath);
                                _context.next = 15;
                                return fetch("/uplift/image-manager/resize-image", {
                                  credentials: "same-origin",
                                  cache: "no-cache",
                                  body: fData,
                                  method: "PATCH"
                                });
                              case 15:
                                response = _context.sent;
                                if (!(response.status === 200)) {
                                  _context.next = 29;
                                  break;
                                }
                                _context.prev = 17;
                                _context.next = 20;
                                return response.json();
                              case 20:
                                data = _context.sent;
                                _context.next = 26;
                                break;
                              case 23:
                                _context.prev = 23;
                                _context.t0 = _context["catch"](17);
                                errors.push("The server responded with invalid JSON.");
                              case 26:
                                if (data.status === -1) {
                                  errors.push(data.error);
                                }
                                _context.next = 30;
                                break;
                              case 29:
                                errors.push(response.statusText);
                              case 30:
                                resolve();
                              case 31:
                              case "end":
                                return _context.stop();
                            }
                          }, _callee, null, [[17, 23]]);
                        }));
                        return function (_x) {
                          return _ref.apply(this, arguments);
                        };
                      }());
                    case 3:
                      ++finishedNumber;
                      currentQueueNumber.textContent = String(finishedNumber);
                    case 5:
                    case "end":
                      return _context2.stop();
                  }
                }, _loop);
              });
              _iterator2.s();
            case 13:
              if ((_step2 = _iterator2.n()).done) {
                _context3.next = 17;
                break;
              }
              return _context3.delegateYield(_loop(), "t0", 15);
            case 15:
              _context3.next = 13;
              break;
            case 17:
              _context3.next = 22;
              break;
            case 19:
              _context3.prev = 19;
              _context3.t1 = _context3["catch"](10);
              _iterator2.e(_context3.t1);
            case 22:
              _context3.prev = 22;
              _iterator2.f();
              return _context3.finish(22);
            case 25:
              // Refresh the cache string for previews
              this.imageManager.imageManagerState.currentImageCacheRandomString = String(Math.random());
              _context3.next = 28;
              return this.imageManager.windowManager.mainWindow.refreshCurrentLocation();
            case 28:
              this.imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);
              this.isProcessing = false;
              this.spinnerContainer.style.display = "none";
              if (errors.length > 0) {
                alert("There were errors with some or all of the images processed. Check the developer console for details.");
                console.log(errors);
              }
              return _context3.abrupt("return", errors);
            case 33:
            case "end":
              return _context3.stop();
          }
        }, _callee2, this, [[10, 19, 22, 25]]);
      }));
      function onSubmit() {
        return _onSubmit.apply(this, arguments);
      }
      return onSubmit;
    }()
    /**
     * Function called when this window gets shown
     */
    )
  }, {
    key: "onWindowShown",
    value: function onWindowShown() {
      this.getAcceptableImagesFromSelection();
      this.window.querySelector(".im-resize-max-index").textContent = String(this.queuedImageComponents.length);

      // Reset old stored values from a previous operation
      this.previewsContainer.innerHTML = "";
      this.window.querySelector(".im-resize-current-index").textContent = "1";
      this.currentPreviewIndex = 0;
      this.previewsContainer.style.marginLeft = "-".concat(this.currentPreviewIndex * ResizeWindow.previewMarginShift, "%");
      this.widthInput.value = "";
      this.heightInput.value = "";
      if (this.queuedImageComponents.length === 1) {
        /** @type {ImageComponent} */
        var imageComponentToBeResized = this.queuedImageComponents[0];
        this.constrainCheckbox.checked = true;
        this.constrainCheckbox.parentElement.style.display = "inline-flex";
        this.oHeightInput.value = imageComponentToBeResized.imageHeight;
        this.oWidthInput.value = imageComponentToBeResized.imageWidth;
        this.heightInput.value = imageComponentToBeResized.imageHeight;
        this.widthInput.value = imageComponentToBeResized.imageWidth;
      } else if (this.queuedImageComponents.length > 1) {
        this.constrainCheckbox.checked = false;
        this.constrainCheckbox.parentElement.style.display = "none";
      } else {
        // Shouldn't happen
        console.log("Valid image component selection is empty!");
      }
      this.buildImagePreviews();
    }

    /**
     * @param {string} imageSource
     * @return {HTMLElement}
     */
  }, {
    key: "buildImagePreviewDOM",
    value: function buildImagePreviewDOM(imageSource) {
      var template = document.createElement("im-resize-preview");
      template.innerHTML = "\n\t\t\t<img class=\"im-resize-preview-image\" alt=\"Preview of image after resizing\" src=\"".concat(imageSource, "?cache=").concat(this.imageManager.imageManagerState.currentImageCacheRandomString, "\">\n\t\t");
      this.currentPreviews.push(template);
      this.previewsContainer.append(template);
      return template;
    }

    /**
     * Builds the image previews based on the currently selected image components
     */
  }, {
    key: "buildImagePreviews",
    value: function buildImagePreviews() {
      this.currentPreviews = [];
      var _iterator3 = _createForOfIteratorHelper(this.queuedImageComponents),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var component = _step3.value;
          this.buildImagePreviewDOM(component.uri);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }

    /**
     * Refreshes all of the image previews with the new sizes
     * @param {HTMLInputElement} inputElementChanged Will have a name of "width" or "height"
     */
  }, {
    key: "refreshPreviewsWithNewSizes",
    value: function refreshPreviewsWithNewSizes(inputElementChanged) {
      var nameOfInputElementChanged = inputElementChanged.getAttribute("name");
      var heightInput = parseInt(this.heightInput.value);
      var widthInput = parseInt(this.widthInput.value);
      if (this.queuedImageComponents.length > 1) {
        var _iterator4 = _createForOfIteratorHelper(this.currentPreviews),
          _step4;
        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var previewContainer = _step4.value;
            var preview = previewContainer.querySelector("img");
            if (!isNaN(heightInput) && !isNaN(widthInput)) {
              preview.setAttribute("width", "".concat(widthInput, "px"));
              preview.setAttribute("height", "".concat(heightInput, "px"));
            } else {
              if (!isNaN(heightInput)) {
                preview.removeAttribute("width");
                preview.setAttribute("height", "".concat(heightInput, "px"));
              } else if (!isNaN(widthInput)) {
                preview.removeAttribute("height");
                preview.setAttribute("width", "".concat(widthInput, "px"));
              } else {
                // Neither?
                preview.removeAttribute("height");
                preview.removeAttribute("width");
              }
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      } else if (this.queuedImageComponents.length === 1) {
        /** @type {HTMLImageElement} */
        var _preview = this.currentPreviews[0].querySelector("img");

        // Only a single image change. Check for aspect ratio retention
        if (this.constrainCheckbox.checked) {
          var aspectRatio = parseInt(this.oHeightInput.value) / parseInt(this.oWidthInput.value);
          if (nameOfInputElementChanged === "height") {
            this.widthInput.value = Math.round(inputElementChanged.value / aspectRatio);
          } else if (nameOfInputElementChanged === "width") {
            this.heightInput.value = Math.round(aspectRatio * inputElementChanged.value);
          }

          // Only set the height attribute to avoid stretching the preview image when aspect ratio is constrained
          _preview.removeAttribute("width");
          _preview.setAttribute("height", "".concat(this.heightInput.value, "px"));
        } else {
          // No aspect ratio retention
          // Set both height and width when no constraint is applied
          _preview.setAttribute("width", "".concat(this.widthInput.value, "px"));
          _preview.setAttribute("height", "".concat(this.heightInput.value, "px"));
        }
      }
    }

    /**
     * When any size input boxes are changed
     * @param {HTMLInputElement} inputElementChanged
     */
  }, {
    key: "onSizeInputChanged",
    value: function onSizeInputChanged(inputElementChanged) {
      this.refreshPreviewsWithNewSizes(inputElementChanged);
    }
  }]);
}();
_defineProperty(ResizeWindow, "previewMarginShift", "90");
export default ResizeWindow;