function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var AdminBar = /*#__PURE__*/function () {
  function AdminBar() {
    var _this = this;
    _classCallCheck(this, AdminBar);
    _defineProperty(this, "barContainer", document.querySelector("public-front-end-admin-bar"));
    _defineProperty(this, "openButton", document.querySelector("#public-front-end-admin-bar-toggle"));
    _defineProperty(this, "hideButton", document.querySelector("#ucms-hide-bar"));
    if (this.barContainer !== null) {
      if (this.getIsCollapsedFromMemory()) {
        this.hide();
      } else {
        this.show();
      }
      this.openButton.addEventListener("click", function () {
        _this.onOpenButtonClicked();
      });
      this.hideButton.addEventListener("click", function () {
        _this.onHideButtonClicked();
      });
    }
  }
  return _createClass(AdminBar, [{
    key: "onOpenButtonClicked",
    value: function onOpenButtonClicked() {
      this.show();
    }
  }, {
    key: "onHideButtonClicked",
    value: function onHideButtonClicked() {
      this.hide();
    }

    /**
     * Checks if the key that represents the admin bar being collapsed on page load exists. If it does, then the
     * admin bar should start as collapsed.
     * @returns {boolean}
     */
  }, {
    key: "getIsCollapsedFromMemory",
    value: function getIsCollapsedFromMemory() {
      return localStorage.getItem(this.constructor.localStorageKeyName) !== null;
    }
  }, {
    key: "show",
    value: function show() {
      localStorage.removeItem(this.constructor.localStorageKeyName);
      this.barContainer.style.display = null;
      this.openButton.style.display = "none";
    }
  }, {
    key: "hide",
    value: function hide() {
      // When hidden, show the openButton
      localStorage.setItem(this.constructor.localStorageKeyName, "1");
      this.barContainer.style.display = "none";
      this.openButton.style.display = null;
    }
  }]);
}();
_defineProperty(AdminBar, "localStorageKeyName", "uplift-admin-bar-is-collapsed");
export default new AdminBar();