/**
* Fetching and initiating rendering for push history
*/

import PushUIBuilder from "./_ui-builder.js";
var PushHistoryFetcher = {};

/**
* Makes a fetch for push history and then calls a render for each item found
*
* This function will also change some UI to make loading a better UX
*
* @return {null}
*/
PushHistoryFetcher.fetchPushHistory = function () {
  var loader = document.getElementById("loader");
  var noHistoryContainer = document.getElementById("no-history");
  var coreDirectory = document.getElementById("cms-install-directory").value;
  document.getElementById("history-container").innerHTML = "";
  loader.style.display = "block";
  fetch(coreDirectory + "fbm-core/Controllers/PushNotifications/GetNotificationHistory.php", {
    cache: "no-cache",
    credentials: "same-origin",
    method: "get"
  }).then(function (response) {
    response.json().then(function (rObject) {
      loader.style.display = "none";
      if (rObject.status === 1) {
        if (rObject.history.length === 0) {
          noHistoryContainer.style.display = "block";
        } else {
          rObject.history.forEach(function (historyData) {
            PushUIBuilder.renderHistoryItem(historyData);
          });
        }
      }
    });
  });
};
export default PushHistoryFetcher;