function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
import PushHistoryFetcher from "./_history-fetcher.js";
(function () {
  var form = document.getElementById("push-form");
  var coreDirectory = document.getElementById("cms-install-directory").value;
  var errorContainer = document.getElementById("push-form-error");
  var successContainer = document.getElementById("push-success");
  var statusText = document.getElementById("status-text");
  var submitButton;
  var _iterator = _createForOfIteratorHelper(form.getElementsByTagName("button")),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var button = _step.value;
      if (button.getAttribute("type") === "submit") {
        submitButton = button;
        break;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  form.addEventListener("submit", function (e) {
    e.preventDefault();
    if (submitButton.classList.contains("disabled")) {
      return;
    }
    statusText.innerHTML = "sending notification...";
    submitButton.classList.add("disabled");
    errorContainer.style.display = "none";
    successContainer.style.display = "none";
    fetch(coreDirectory + "fbm-core/Controllers/PushNotifications/SendMassNotification.php", {
      cache: "no-cache",
      credentials: "same-origin",
      method: "post",
      body: new FormData(form)
    }).then(function (response) {
      response.json().then(function (rObject) {
        submitButton.classList.remove("disabled");
        if (rObject.status === -1) {
          errorContainer.style.display = "block";
          errorContainer.innerHTML = rObject.error;
          statusText.innerHTML = "send error";
        } else if (rObject.status === 1) {
          // Success, refetch history
          successContainer.style.display = "block";
          successContainer.innerHTML = "Successfully sent to " + rObject.totalDevicesReached + " devices";
          PushHistoryFetcher.fetchPushHistory();
          statusText.innerHTML = "waiting...";

          // Reset the fields
          var _iterator2 = _createForOfIteratorHelper(document.getElementsByClassName("form-control")),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var control = _step2.value;
              control.value = "";
            }

            // After 5 seconds, hide the success container
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
          setTimeout(function () {
            successContainer.style.display = "none";
          }, 5000);
        }
      });
    });
  });
  PushHistoryFetcher.fetchPushHistory();
})();