function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ManagePageData from "../modals/ManagePageData.js";
import VirtualParent from "./VirtualParent.js";
import PageData from "./PageData.js";
import ContentFilter from "./ContentFilter.js";
import FeaturedImage from "../buttons/FeaturedImage.js";
var PageComponent = /*#__PURE__*/function () {
  /**
   * @param {{pageName: string, type: string, slug: string, seoTitle: string, seoDescription: string, content: string, featuredImageURI: string, featuredImageThumbURI: string, creationTimestamp: int, cityName: ?string, stateName: ?string, stateAbbreviation: ?string}} pageData
   */
  function PageComponent(pageData) {
    _classCallCheck(this, PageComponent);
    _defineProperty(this, "id", void 0);
    _defineProperty(this, "pageName", void 0);
    _defineProperty(this, "pageType", void 0);
    _defineProperty(this, "slug", void 0);
    _defineProperty(this, "title", void 0);
    _defineProperty(this, "description", void 0);
    _defineProperty(this, "cityName", void 0);
    _defineProperty(this, "stateName", void 0);
    _defineProperty(this, "stateAbbreviation", void 0);
    _defineProperty(this, "featuredImageURI", void 0);
    _defineProperty(this, "featuredImageThumbURI", void 0);
    /** @type {null|int} */
    _defineProperty(this, "pageParentID", null);
    /** @type {PageData[]} */
    _defineProperty(this, "pageDatas", []);
    _defineProperty(this, "content", void 0);
    // Run the page content through a DOM manipulation filter
    var filteredContent = ContentFilter.filterContent(pageData.content);

    // Fix the slug if it doesn't start with a forward slash
    // if (!pageData.slug.startsWith("/")){
    // 	pageData.slug = `/${pageData.slug}`;
    // }

    this.id = this.constructor.nextID++;
    this.pageName = pageData.pageName;
    this.pageType = pageData.type;
    this.slug = pageData.slug;
    this.title = pageData.seoTitle;
    this.description = pageData.seoDescription;
    this.content = filteredContent;
    this.dom = this.getDOM();
    if (this.pageType === "City") {
      if ("cityName" in pageData) {
        this.cityName = pageData.cityName;
        new PageData(this, "CITY_NAME", this.cityName);
      }
      if ("stateName" in pageData) {
        this.stateName = pageData.stateName;
        new PageData(this, "STATE_NAME", this.stateName);
      }
      if ("stateAbbreviation" in pageData) {
        this.stateAbbreviation = pageData.stateAbbreviation;
        new PageData(this, "STATE_NAME_SHORTHAND", this.stateAbbreviation);
      }
    }
    if (this.pageType !== "General") {
      this.featuredImageURI = pageData.featuredImageURI;
      this.featuredImageThumbURI = pageData.featuredImageThumbURI;
    }
    this.constructor.cache.push(this);
  }

  /**
   * @returns {VirtualParent[]}
   */
  return _createClass(PageComponent, [{
    key: "getAncestorArray",
    value: function getAncestorArray() {
      var ancestorVirtualParents = [];
      var currentParentID = this.pageParentID;
      console.log("".concat(this.pageName, " Parent ID: ").concat(currentParentID));
      while (currentParentID !== null) {
        var virtualParent = VirtualParent.getByID(currentParentID);
        ancestorVirtualParents.push(virtualParent);
        if (virtualParent.parentID !== null) {
          currentParentID = virtualParent.parentID;
        } else {
          break;
        }
      }
      ancestorVirtualParents.reverse();
      return ancestorVirtualParents;
    }
  }, {
    key: "getDOM",
    value: function getDOM(event) {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("page-component", "row");
      template.innerHTML = "\n\t\t\t<div class=\"col-xl-6\">\n\t\t\t\t<div class=\"mb-1\">\n\t\t\t\t\t<div class=\"input-group input-group-sm\">\n\t\t\t\t\t\t<label for=\"page-name-input-".concat(this.id, "\" class=\"input-group-text\">\n\t\t\t\t\t\t\t<i class=\"bi bi-signpost-fill me-1\"></i><span>Name</span>\n\t\t\t\t\t\t</label>\n\t\t\t\t\t\t<input id=\"page-name-input-").concat(this.id, "\" type=\"text\" class=\"form-control form-control-sm page-name-input\" value=\"").concat(this.pageName, "\">\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"mb-1\">\n\t\t\t\t\t<div class=\"input-group input-group-sm\">\n\t\t\t\t\t\t<label for=\"page-route-input-").concat(this.id, "\" class=\"input-group-text\">\n\t\t\t\t\t\t\t<i class=\"bi bi-signpost-fill me-1\"></i><span>Slug</span>\n\t\t\t\t\t\t</label>\n\t\t\t\t\t\t<input id=\"page-route-input-").concat(this.id, "\" type=\"text\" class=\"form-control form-control-sm page-route-input\" value=\"").concat(this.slug, "\">\n\t\t\t\t\t\t<select class=\"form-control page-parent-input\">\n\t\t\t\t\t\t\t<option value=\"-1\">- No Parent</option>\n\t\t\t\t\t\t</select>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"\">\n\t\t\t\t\t<button type=\"button\" class=\"manage-custom-data-button btn btn-light btn-sm rounded-0\">\n\t\t\t\t\t\t<i class=\"bi bi-clipboard2-data-fill\"></i>\n\t\t\t\t\t\t<span>Page Data</span>\n\t\t\t\t\t</button>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");

      // Insert the featured image if the page isn't General
      if (this.pageType !== "General") {
        template.innerHTML += "\n\t\t\t\t<div class=\"col-xl-6\" id=\"page-featured-image\">\n\t\t\t\t\t<input type=\"hidden\" name=\"featured-image-uri\" id=\"featured-image-uri-input-".concat(this.id, "\" class=\"featured-image-uri-input\" value=\"\">\n\t\t\t\t\t<input type=\"hidden\" name=\"featured-image-thumb-uri\" id=\"featured-image-thumb-uri-input-").concat(this.id, "\" class=\"featured-image-thumb-uri-input\" value=\"\">\n\t\t\t\t\t<div id=\"featured-image-contents-container\">\n\t\t\t\t\t\t<div id=\"featured-image-container\">\n\t\t\t\t\t\t\t<img id=\"featured-image-").concat(this.id, "\" class=\"featured-image\" alt=\"Featured image\" src=\"\">\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div id=\"featured-image-buttons\">\n\t\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t\t<button type=\"button\" class=\"mb-2 btn btn-primary set-featured-image-button\">\n\t\t\t\t\t\t\t\t\t<i class=\"bi bi-image-fill\"></i>\n\t\t\t\t\t\t\t\t\t<span>Set Image</span>\n\t\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t\t<button type=\"button\" class=\"btn btn-danger clear-featured-image-button\">\n\t\t\t\t\t\t\t\t\t<i class=\"bi bi-x-circle-fill\"></i>\n\t\t\t\t\t\t\t\t\t<span>Clear</span>\n\t\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t");
      }
      var pageNameInput = template.querySelector(".page-name-input");
      var pageRouteInput = template.querySelector(".page-route-input");
      var pageParentInput = template.querySelector(".page-parent-input");
      var manageCustomDataButton = template.querySelector(".manage-custom-data-button");
      var pageFeaturedImage = template.querySelector("#page-featured-image");
      var featuredImage = template.querySelector(".featured-image");
      var setFeaturedImageButton = template.querySelector(".set-featured-image-button");
      var clearFeaturedImageButton = template.querySelector(".clear-featured-image-button");
      var featuredImageURIInput = template.querySelector(".featured-image-uri-input");
      var featuredImageThumbURIInput = template.querySelector(".featured-image-thumb-uri-input");
      pageNameInput.addEventListener("input", function () {
        _this.pageName = pageNameInput.value.trim();
      });
      pageRouteInput.addEventListener("input", function () {
        _this.slug = pageRouteInput.value.trim();
      });
      pageParentInput.addEventListener("input", function () {
        var parentIDInt = parseInt(pageParentInput.value);
        if (isNaN(parentIDInt) || parentIDInt === -1) {
          _this.pageParentID = null;
        } else {
          _this.pageParentID = parentIDInt;
        }
      });
      manageCustomDataButton.addEventListener("click", function () {
        ManagePageData.setCurrentPageComponent(_this);
        ManagePageData.show();
      });
      if (pageFeaturedImage) {
        featuredImage.addEventListener("click", function () {
          FeaturedImage.setImageButtonClicked(_this.id);
        });
        setFeaturedImageButton.addEventListener("click", function () {
          FeaturedImage.setImageButtonClicked(_this.id);
        });
        clearFeaturedImageButton.addEventListener("click", function () {
          FeaturedImage.clearFeaturedImage(_this.id);
        });
        featuredImageURIInput.addEventListener("input", function () {
          _this.featuredImageURI = featuredImageURIInput.value;
        });
        featuredImageThumbURIInput.addEventListener("input", function () {
          _this.featuredImageThumbURI = featuredImageThumbURIInput.value;
        });
      }
      if (this.pageType === "General") {
        this.constructor.pageContainers.General.append(template);
      } else if (this.pageType === "Service") {
        this.constructor.pageContainers.Service.append(template);
      } else if (this.pageType === "City") {
        this.constructor.pageContainers.City.append(template);
      } else if (this.pageType === "Blog") {
        this.constructor.pageContainers.Blog.append(template);
      } else if (this.pageType === "Project") {
        this.constructor.pageContainers.Project.append(template);
      }
      return template;
    }
  }], [{
    key: "getPagesOfType",
    value: function getPagesOfType(pageType) {
      var pages = [];
      var _iterator = _createForOfIteratorHelper(PageComponent.cache),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var pageComponent = _step.value;
          if (pageComponent.pageType === pageType) {
            pages.push(pageComponent);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return pages;
    }
  }]);
}();
_defineProperty(PageComponent, "nextID", 1);
/** @type {PageComponent[]} */
_defineProperty(PageComponent, "cache", []);
_defineProperty(PageComponent, "pageContainers", {
  "General": document.querySelector("#general-pages-container"),
  "Service": document.querySelector("#service-pages-container"),
  "City": document.querySelector("#city-pages-container"),
  "Blog": document.querySelector("#blog-pages-container"),
  "Project": document.querySelector("#project-pages-container")
});
export default PageComponent;