function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var VirtualParent = /*#__PURE__*/function () {
  function VirtualParent(name, parentID) {
    _classCallCheck(this, VirtualParent);
    _defineProperty(this, "id", void 0);
    _defineProperty(this, "name", void 0);
    /** @type {null|int} */
    _defineProperty(this, "parentID", null);
    _defineProperty(this, "uri", "");
    /** @type {HTMLOptionElement[]} */
    _defineProperty(this, "linkedOptions", []);
    parentID = parseInt(parentID);
    if (parentID === -1) {
      parentID = null;
    }
    this.id = this.constructor.nextID++;
    this.parentID = parentID;
    this.name = name;
    this.dom = this.getDOM();
    this.constructor.cache.push(this);
    this.constructor.fireNewVirtualParent(this);
  }
  return _createClass(VirtualParent, [{
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("virtual-parent-component");
      template.innerHTML = "\n\t\t\t<div class=\"virtual-parent-column-widths\">\n\t\t\t\t<div class=\"id-column\">\n\t\t\t\t\t<span>".concat(this.id, "</span>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"name-column\">\n\t\t\t\t\t<input type=\"text\" class=\"form-control form-control-sm virtual-parent-name-input\" value=\"").concat(this.name, "\">\n\t\t\t\t</div>\n\t\t\t\t<div class=\"uri-column\">\n\t\t\t\t\t<input type=\"text\" class=\"form-control form-control-sm virtual-parent-uri-input\" value=\"").concat(this.uri, "\">\n\t\t\t\t</div>\n\t\t\t\t<div class=\"parent-name-column\">\n\t\t\t\t\t<select class=\"form-control form-control-sm virtual-parent-parent-selector\">\n\t\t\t\t\t\t<option value=\"-1\">- None -</option>\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"delete-button-column\">\n\t\t\t\t\t<button type=\"button\" class=\"delete-button text-danger btn-sm btn btn-link\">\n\t\t\t\t\t\t<i class=\"bi bi-x-lg\"></i>\n\t\t\t\t\t</button>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"forward-slash-warning\" style=\"display:none;\">\n\t\t\t\t<small class=\"text-danger\">URI stubs must begin with a forward slash to be valid.</small>\n\t\t\t</div>\n\t\t");
      var nameInput = template.querySelector(".virtual-parent-name-input");
      var uriInput = template.querySelector(".virtual-parent-uri-input");
      var virtualParentParentSelector = template.querySelector(".virtual-parent-parent-selector");
      var deleteButton = template.querySelector(".delete-button");

      // Change any <option> elements' textContent that is linked to this VirtualParent
      nameInput.addEventListener("input", function () {
        var nameValue = nameInput.value.trim();
        _this.name = nameValue;
        var _iterator = _createForOfIteratorHelper(_this.linkedOptions),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var option = _step.value;
            option.textContent = nameValue;
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      });
      uriInput.addEventListener("input", function () {
        _this.uri = uriInput.value.trim();
        if (!_this.uri.startsWith("/")) {
          _this.showForwardSlashWarning();
        } else {
          _this.hideForwardSlashWarning();
        }
      });

      // Preload in all the existing virtual parents
      var _iterator2 = _createForOfIteratorHelper(this.constructor.cache),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var existingVirtualParentComponent = _step2.value;
          if (existingVirtualParentComponent.id !== this.id) {
            var option = document.createElement("option");
            option.setAttribute("value", existingVirtualParentComponent.id);
            option.textContent = existingVirtualParentComponent.name;
            existingVirtualParentComponent.linkedOptions.push(option);
            virtualParentParentSelector.append(option);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      if (this.parentID !== null) {
        virtualParentParentSelector.value = this.parentID;
      }
      virtualParentParentSelector.addEventListener("change", function () {
        _this.parentID = parseInt(virtualParentParentSelector.value);
      });
      deleteButton.addEventListener("click", function () {
        _this.constructor.removeByID(_this.id);
      });
      this.constructor.container.append(template);
      return template;
    }
  }, {
    key: "showForwardSlashWarning",
    value: function showForwardSlashWarning() {
      var warningContainer = this.dom.querySelector(".forward-slash-warning");
      warningContainer.style.display = null;
    }
  }, {
    key: "hideForwardSlashWarning",
    value: function hideForwardSlashWarning() {
      var warningContainer = this.dom.querySelector(".forward-slash-warning");
      warningContainer.style.display = "none";
    }
  }], [{
    key: "getByID",
    value:
    /**
     * @param {int} id
     * @returns VirtualParent | null
     */
    function getByID(id) {
      var _iterator3 = _createForOfIteratorHelper(VirtualParent.cache),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var component = _step3.value;
          if (component.id === id) {
            return component;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return null;
    }

    /**
     * @param {int} id
     */
  }, {
    key: "removeByID",
    value: function removeByID(id) {
      var _iterator4 = _createForOfIteratorHelper(VirtualParent.cache.entries()),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var _step4$value = _slicedToArray(_step4.value, 2),
            index = _step4$value[0],
            component = _step4$value[1];
          if (component.id === id) {
            var _iterator5 = _createForOfIteratorHelper(component.linkedOptions),
              _step5;
            try {
              for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                var option = _step5.value;
                option.remove();
              }
            } catch (err) {
              _iterator5.e(err);
            } finally {
              _iterator5.f();
            }
            component.dom.remove();
            VirtualParent.cache.splice(index, 1);
            break;
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }
  }, {
    key: "onNewVirtualParent",
    value: function onNewVirtualParent(callback) {
      _onNewVirtualParentCallbacks._.push(callback);
    }
  }, {
    key: "fireNewVirtualParent",
    value: function fireNewVirtualParent(virtualComponent) {
      var _iterator6 = _createForOfIteratorHelper(_onNewVirtualParentCallbacks._),
        _step6;
      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var callback = _step6.value;
          callback(virtualComponent);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
  }]);
}();
_defineProperty(VirtualParent, "nextID", 1);
/** @type {VirtualParent[]} */
_defineProperty(VirtualParent, "cache", []);
_defineProperty(VirtualParent, "container", document.querySelector("#virtual-parents-container"));
var _onNewVirtualParentCallbacks = {
  _: []
};
export default VirtualParent;