function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var AdditionalAddress = /*#__PURE__*/function () {
  function AdditionalAddress(id) {
    _classCallCheck(this, AdditionalAddress);
    _defineProperty(this, "id", void 0);
    _defineProperty(this, "dom", void 0);
    this.id = id;
    this.dom = this.getDOM();
    this.constructor.cache.push(this);
  }
  return _createClass(AdditionalAddress, [{
    key: "render",
    value: function render() {
      AdditionalAddress.container.append(this.dom);
    }

    /**
     * Converts the address fields into an array with the following keys
     * street, city, state, postal, country
     * @return {{street: string, city: string, state: string, postal: string, country: string}}
     */
  }, {
    key: "getDataAsArray",
    value: function getDataAsArray() {
      var street = this.dom.querySelector(".additional-street-input").value;
      var city = this.dom.querySelector(".additional-city-input").value;
      var state = this.dom.querySelector(".additional-state-input").value;
      var postal = this.dom.querySelector(".additional-postal-input").value;
      var country = this.dom.querySelector(".additional-country-input").value;
      return {
        street: street,
        city: city,
        state: state,
        postal: postal,
        country: country
      };
    }

    /**
     * Loads existing address data into this instance
     * @param {string} street
     * @param {string} city
     * @param {string} state
     * @param {string} postal
     * @param {string} country
     */
  }, {
    key: "loadExistingData",
    value: function loadExistingData(street, city, state, postal, country) {
      this.dom.querySelector(".additional-street-input").value = street;
      this.dom.querySelector(".additional-city-input").value = city;
      this.dom.querySelector(".additional-state-input").value = state;
      this.dom.querySelector(".additional-postal-input").value = postal;
      this.dom.querySelector(".additional-country-input").value = country;
    }
  }, {
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("additional-address-container");
      template.innerHTML = "\n\t\t\t<div class=\"card\">\n\t\t\t\t<div class=\"card-header\">\n\t\t\t\t\t<h4 class=\"mb-0\">Additional Address</h4>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"card-body\">\n\t\t\t\t\t<div class=\"my-2\">\n\t\t\t\t\t\t<label for=\"\">Additional Street</label>\n\t\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-geo-fill\"></i></span>\n\t\t\t\t\t\t\t<input type=\"text\" autocomplete=\"offf\" class=\"form-control form-control-sm additional-street-input\">\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"my-2\">\n\t\t\t\t\t\t<label for=\"\">Additional City</label>\n\t\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-geo-fill\"></i></span>\n\t\t\t\t\t\t\t<input type=\"text\" autocomplete=\"offf\" class=\"form-control form-control-sm additional-city-input\">\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"container-fluid p-0\">\n\t\t\t\t\t\t<div class=\"row my-2\">\n\t\t\t\t\t\t\t<div class=\"col-xl\">\n\t\t\t\t\t\t\t\t<label for=\"\">Additional State (abbr.)</label>\n\t\t\t\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-geo-fill\"></i></span>\n\t\t\t\t\t\t\t\t\t<input type=\"text\" autocomplete=\"offf\" class=\"form-control form-control-sm additional-state-input\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-xl\">\n\t\t\t\t\t\t\t\t<label for=\"\">Additional Postal</label>\n\t\t\t\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-geo-fill\"></i></span>\t\n\t\t\t\t\t\t\t\t\t<input type=\"text\" autocomplete=\"offf\" class=\"form-control form-control-sm additional-postal-input\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"my-2\">\n\t\t\t\t\t\t<label for=\"\">Country (abbr.)</label>\n\t\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-geo-fill\"></i></span>\n\t\t\t\t\t\t\t<input type=\"text\" autocomplete=\"offf\" class=\"form-control form-control-sm additional-country-input\">\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<hr>\n\t\t\t\t\t<div class=\"mt-2\">\n\t\t\t\t\t\t<button class=\"delete-button btn btn-sm btn-danger\">\n\t\t\t\t\t\t\t<i class=\"bi bi-trash-fill\"></i>\n\t\t\t\t\t\t\t<span>Remove Address</span>\n\t\t\t\t\t\t</button>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t";
      var deleteButton = template.querySelector(".delete-button");
      deleteButton.addEventListener("click", function () {
        _this.onDeleteButtonClicked();
      });
      return template;
    }
  }, {
    key: "onDeleteButtonClicked",
    value: function onDeleteButtonClicked() {
      AdditionalAddress.removeInstance(this);
    }
  }], [{
    key: "removeInstance",
    value: function removeInstance(instance) {
      instance.dom.remove();
      var _iterator = _createForOfIteratorHelper(AdditionalAddress.cache.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            index = _step$value[0],
            value = _step$value[1];
          if (value === instance) {
            AdditionalAddress.cache.splice(index, 1);
            break;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }]);
}();
/** @type {AdditionalAddress[]} */
_defineProperty(AdditionalAddress, "cache", []);
_defineProperty(AdditionalAddress, "container", document.querySelector("#additional-addresses"));
export default AdditionalAddress;