function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ContextMenu = /*#__PURE__*/function () {
  /**
  * Constructs a new context menu to be rendered at the provided
  * coordinates
  * @param {int} x
  * @param {int} y
  */
  function ContextMenu(x, y) {
    _classCallCheck(this, ContextMenu);
    /** @type {HTMLElement} */
    _defineProperty(this, "dom", void 0);
    this.x = x;
    this.y = y;
    this.buildDOM();

    // Close the existing one
    if (ContextMenu.currentContextMenu !== null) {
      ContextMenu.currentContextMenu.cleanup();
    }
    ContextMenu.currentContextMenu = this;
  }

  /**
  * Gets the DOM
  */
  return _createClass(ContextMenu, [{
    key: "buildDOM",
    value: function buildDOM() {
      var _this = this;
      this.dom = document.createElement("div");
      this.dom.classList.add("pseudo-context-menu");
      this.dom.style.left = "".concat(this.x, "px");
      this.dom.style.top = "".concat(this.y, "px");
      window.addEventListener("click", function (e) {
        _this.onWindowClick(e);
      });
      window.addEventListener("contextmenu", function (e) {
        _this.onWindowContextMenu(e);
      });
    }

    /**
    * Check if a context menu was requested outside of the current one
    */
  }, {
    key: "onWindowContextMenu",
    value: function onWindowContextMenu(e) {
      if (e.target.closest(".pseudo-context-menu") !== this.dom) {
        this.cleanup();
      }
    }

    /**
    * Checks for clicks outside of the context menu
    */
  }, {
    key: "onWindowClick",
    value: function onWindowClick(e) {
      if (e.target.closest(".pseudo-context-menu") !== this.dom) {
        this.cleanup();
      }
    }

    /**
    * Adds a button with a click callback.
    * @param {string} html
    * @returns {HTMLButtonElement} The button
    */
  }, {
    key: "addButton",
    value: function addButton(html) {
      var button = document.createElement("button");
      button.classList.add("cm-button");
      button.innerHTML = html;
      this.dom.append(button);
      return button;
    }

    /**
    * Adds a separator element to the menu
    * @returns {HTMLDivElement} The div
    */
  }, {
    key: "addSeparator",
    value: function addSeparator() {
      var separator = document.createElement("div");
      separator.classList.add("cm-separator");
      this.dom.append(separator);
      return separator;
    }

    /**
    * Renders the DOM
    */
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      document.body.append(this.dom);

      // Determine if this context menu is overflowing on the Y axis or X axis
      setTimeout(function () {
        // Y axis check
        var maxViewportYPosition = document.documentElement.clientHeight;
        var cmHeight = _this2.dom.clientHeight;
        var bottomYPosition = _this2.y + cmHeight;
        if (bottomYPosition > maxViewportYPosition) {
          _this2.y -= cmHeight;
          _this2.dom.style.top = "".concat(_this2.y, "px");
        }

        // X axis check
        var maxViewportXPosition = document.documentElement.clientWidth;
        var cmWidth = _this2.dom.clientWidth;
        var rightXPosition = _this2.x + cmWidth;
        if (rightXPosition > maxViewportXPosition) {
          _this2.x -= cmWidth;
          _this2.dom.style.left = "".concat(_this2.x, "px");
        }
      }, 1);
    }

    /**
    * Cleans up the DOM and object
    */
  }, {
    key: "cleanup",
    value: function cleanup() {
      this.dom.remove();
      ContextMenu.currentContextMenu = null;
    }
  }]);
}();
/**
 * @type {ContextMenu}
 */
_defineProperty(ContextMenu, "currentContextMenu", null);
export default ContextMenu;