const backendStub = `/uplift`;
const apiStub = `${backendStub}/api/private`;
const activeVersionStub = `/v1`;

export default {
	activityLogs:`${backendStub}/activity-logs`,
	apacheManager: {
		editHtaccess:`${backendStub}/htaccess`,
		getHtaccess:`${backendStub}/htaccess`
	},
	easyEditor: {
		getPhoneAndFaxNumbers:`${backendStub}/easy-editor/phone-and-fax-numbers`,
		getPages:`${backendStub}/easy-editor/pages`,
		savePage:`${backendStub}/easy-editor/save-page`
	},
	galleries:{
		fetchGalleries:`${backendStub}/gallery-manager/galleries`,
		newGallery:`${backendStub}/gallery-manager/gallery`,
		renameGallery:`${backendStub}/gallery-manager/gallery`,
		deleteGallery:`${backendStub}/gallery-manager/gallery`,
		fetchGalleryMembers:`${backendStub}/gallery-manager/gallery`,
		addMembersToGallery:`${backendStub}/gallery-manager/gallery`,
		updateGalleryMembersPositions:`${backendStub}/gallery-manager/gallery`,
		updateGalleryMemberAltText:`${backendStub}/gallery-manager/gallery`
	},
	imageManager: {
		fetchImageDirectories: `${apiStub}${activeVersionStub}/image-manager/fetch-directories-recursively`,
		fetchImagesInDirectory: `${apiStub}${activeVersionStub}/image-manager/fetch-directory-images`,
		moveImage: `${apiStub}${activeVersionStub}/image-manager/move-image`,
		renameImage:`${apiStub}${activeVersionStub}/image-manager/rename-image-file`,
		resizeImage:`${apiStub}${activeVersionStub}/image-manager/resize-image`,
		cropImage:`${apiStub}${activeVersionStub}/image-manager/crop-image`,
		uploadImageFile:`${apiStub}${activeVersionStub}/image-manager/upload-image-file`,
		uploadImageByURLSource:`${apiStub}${activeVersionStub}/image-manager/upload-image-by-url-source`,
		cloneImage:`${apiStub}${activeVersionStub}/image-manager/clone-image`,
		newDirectory:`${apiStub}${activeVersionStub}/image-manager/new-directory`,
		renameDirectory:`${apiStub}${activeVersionStub}/image-manager/rename-directory`,
		deleteDirectory:`${apiStub}${activeVersionStub}/image-manager/delete-directory`,
		moveDirectory:`${apiStub}${activeVersionStub}/image-manager/move-directory`,
		regenThumb:`${apiStub}${activeVersionStub}/image-manager/regenerate-thumb`,
		deleteImage:`${apiStub}${activeVersionStub}/image-manager/delete-image`
	},
	login:`${apiStub}${activeVersionStub}/login`,
	pageEditor: {
		editor:`${backendStub}/page-editor`,
		createBlankPage: `${backendStub}/page-editor/page`,
		getListOfPages:`${apiStub}${activeVersionStub}/page-editor/pages`,
		convertPageType:`${apiStub}${activeVersionStub}/page-editor/page-type`,
		deletePage:`${apiStub}${activeVersionStub}/page-editor/page`,
		clonePage:`${apiStub}${activeVersionStub}/page-editor/clone-page`,
		newBlogCategory:`${apiStub}${activeVersionStub}/page-editor/article-category`,
		renameBlogCategory:`${apiStub}${activeVersionStub}/page-editor/article-category`,
		deleteBlogCategory:`${apiStub}${activeVersionStub}/page-editor/article-category`,
		saveBlogCategoryToPage:`${apiStub}${activeVersionStub}/page-editor/article-category`,
		relabelProjectTag:`/fbm-core/Controllers/PageEditor/RelabelProjectTag.php`,
		getGalleries:`/fbm-core/Controllers/ImageGallery/GetGalleries.php`,
		saveGeneral:`${apiStub}${activeVersionStub}/page-editor/save-general`,
		saveService:`${apiStub}${activeVersionStub}/page-editor/save-service`,
		saveBlog:`${apiStub}${activeVersionStub}/page-editor/save-blog`,
		saveProject:`${apiStub}${activeVersionStub}/page-editor/save-project`,
		saveCity:`${apiStub}${activeVersionStub}/page-editor/save-city`,
		newProjectTag:`${apiStub}${activeVersionStub}/page-editor/project-tag`,
		renameProjectTag:`${apiStub}${activeVersionStub}/page-editor/project-tag`,
		deleteProjectTag:`${apiStub}${activeVersionStub}/page-editor/project-tag`,
		saveProjectTagToPageID:`${apiStub}${activeVersionStub}/page-editor/project-tag`,
		removeProjectTagIDFromPageID:`${apiStub}${activeVersionStub}/page-editor/project-tag`
	},
	redirects:{
		newRedirect:`${backendStub}/redirects`,
		editRedirect:`${backendStub}/redirect`,
		deleteRedirect:`${backendStub}/redirect`,
		getRedirects:`${backendStub}/redirects`
	},
	reviews:{
		getReviews:`${backendStub}/reviews`,
		newReview:`${backendStub}/reviews`,
		deleteReview:`${backendStub}/review`,
		editReview:`${backendStub}/review`
	},
	roles:{
		getRoles:`${backendStub}/roles`,
		newRole:`${backendStub}/roles`,
		editRole:`${backendStub}/roles`,
		deleteRole:`${backendStub}/roles`
	},
	settings: {
		saveCompanyInformation:`${backendStub}/save-company-information`,
		saveUpliftSettings:`${backendStub}/save-uplift-settings`,
		saveContentSettings:`${backendStub}/save-content-settings`,
		editRobotSettings: `${backendStub}/robots`,
		changeTheme: `${backendStub}/settings/change-theme`
	},
	sitemapManager: {
		getSitemaps:`${backendStub}/sitemaps`,
		newSitemap: `${backendStub}/sitemaps`,
		editSitemap: `${backendStub}/sitemaps`,
		deleteSitemap: `${backendStub}/sitemaps`
	},
	themeEditor:{
		getDirectoryContents:`${apiStub}${activeVersionStub}/template-manager/theme/list-directory`,
		deleteThemeDirectory:`${apiStub}${activeVersionStub}/template-manager/theme/delete-directory`,
		newThemeDirectory:`${apiStub}${activeVersionStub}/template-manager/theme/new-directory`,
		renameThemeDirectory:`${apiStub}${activeVersionStub}/template-manager/theme/rename-directory`,
		newThemeFile:`${apiStub}${activeVersionStub}/template-manager/theme/new-file`,
		saveThemeFile:`${apiStub}${activeVersionStub}/template-manager/theme/save-file`,
		renameThemeFile:`${apiStub}${activeVersionStub}/template-manager/theme/rename-file`,
		getThemeFileContents:`${apiStub}${activeVersionStub}/template-manager/theme/file-contents`,
		deleteThemeFile:`${apiStub}${activeVersionStub}/template-manager/theme/delete-file`,
		compileSCSSFile:`${apiStub}${activeVersionStub}/template-manager/theme/compile-scss-file`
	},
	themeImporter:{
		downloadTheme:`${backendStub}/theme-importer/download-theme`
	},
	userAccounts:{
		getAccounts:`${backendStub}/user-accounts`,
		newAccount:`${backendStub}/user-accounts`,
		editAccount:`${backendStub}/user-accounts`,
		changePassword:`${backendStub}/user-accounts`,
		changeDisabledStatus:`${backendStub}/user-accounts`
	}
};