class CoverPhotoFileInput{
	input = document.querySelector("#cover-photo-input");

	constructor() {
		this.input.addEventListener("change", /** @param {InputEvent} e */ e => {
			this.onFileInputChanged(this.input, e);
		});
	}

	/**
	 * @param {HTMLInputElement} inputElement
	 * @param {InputEvent} event
	 */
	onFileInputChanged(inputElement, event){
		const file = inputElement.files[0];
		const maxFileSizeInBytes = parseInt(document.querySelector("#max-file-upload-size").getAttribute("data-in-bytes"));
		if (file){
			// Don't let files be 95% max file size
			const paddedMaxFileSizeInBytes = 0.95 * maxFileSizeInBytes;
			const fileSize = file.size;
			if (fileSize >= paddedMaxFileSizeInBytes){
				alert("That file is too large and cannot be submitted. We have removed it. Please optimize or resize that file to submit it.");
				inputElement.value = null;
			}else{
				// It's good
			}
		}
	}
}

export default CoverPhotoFileInput;