class Loader{

	static originalTextualHeadline = "Submitting the project text...";
	static finishedTextualHeadline = "Project text submitted";
	static waitingMediaHeadline = "Waiting to submit the images...";
	static inProcessMediaHeadline = "Submitting your project images...";

	container = document.querySelector("#submitting-loader-container");
	textualSubmissionHeadline = document.querySelector("#textual-submission-headline");
	textualAlert = document.querySelector("#textual-loader-alert-container");
	textualSpinnerContainer = document.querySelector("#textual-section-spinner-container");
	mediaSubmissionHeadline = document.querySelector("#media-submission-headline");
	mediaAlert = document.querySelector("#media-loader-alert-container");
	mediaSpinnerContainer = document.querySelector("#media-section-spinner-container");

	show(){
		this.container.style.display = null;
	}

	setTextualHeadline(text){
		this.textualSubmissionHeadline.textContent = text;
	}

	setMediaHeadline(text){
		this.mediaSubmissionHeadline.textContent = text;
	}

	setTextualLoaderAsInProgress(){
		this.setTextualHeadline(Loader.originalTextualHeadline);
		if (this.textualAlert.classList.contains("alert-success")) {
			this.textualAlert.classList.remove("alert-success");
		}

		if (!this.textualAlert.classList.contains("alert-primary")) {
			this.textualAlert.classList.add("alert-primary");
		}

		this.textualSpinnerContainer.style.display = null;
	}

	setTextualLoaderAsFinished(){
		this.setTextualHeadline(Loader.finishedTextualHeadline);
		if (this.textualAlert.classList.contains("alert-primary")) {
			this.textualAlert.classList.remove("alert-primary");
		}

		if (!this.textualAlert.classList.contains("alert-success")) {
			this.textualAlert.classList.add("alert-success");
		}

		this.textualSpinnerContainer.style.display = "none";
	}

	setMediaLoaderAsWaiting(){
		this.setMediaHeadline(Loader.waitingMediaHeadline);

		if (this.mediaAlert.classList.contains("alert-success")) {
			this.mediaAlert.classList.remove("alert-success");
		}

		if (this.mediaAlert.classList.contains("alert-danger")) {
			this.mediaAlert.classList.remove("alert-danger");
		}

		if (this.mediaAlert.classList.contains("alert-primary")) {
			this.mediaAlert.classList.remove("alert-primary");
		}

		if (!this.mediaAlert.classList.contains("alert-warning")) {
			this.mediaAlert.classList.add("alert-warning");
		}

		this.mediaSpinnerContainer.style.display = "none";
	}

	setMediaLoaderAsInProgress(){
		this.setMediaHeadline(Loader.inProcessMediaHeadline);

		if (this.mediaAlert.classList.contains("alert-warning")) {
			this.mediaAlert.classList.remove("alert-warning");
		}

		if (!this.mediaAlert.classList.contains("alert-primary")) {
			this.mediaAlert.classList.add("alert-primary");
		}

		this.mediaSpinnerContainer.style.display = null;
	}

	hide(){
		this.container.style.display = "none";
	}
}

export default Loader;