export class ProjectTags{
	ButtonsContainer = document.querySelector("#tags-buttons-list");
	Loader = document.querySelector("#tags-loader");
	/**
	 * List of all project tags currently fetched
	 * @type {{id: number, label: string}[]}
	 */
	Tags = [];

	constructor() {
		this.Init();
	}

	async Init(){
		this.Tags = await this.FetchProjectTags()
		for (const tag of this.Tags){
			this.BuildButton(tag);
		}

		// Hides the loader now the tags are loaded in
		this.Loader.classList.remove("d-inline-block");
		this.Loader.style.display = "none";
	}

	/**
	 * @returns {number[]}
	 * @constructor
	 */
	GetSelectedTags(){
		const selectedTagIds = [];
		for (const button of Array.from(this.ButtonsContainer.querySelectorAll(("button")))){
			if (button.classList.contains("selected")){
				const tagId = parseInt(button.getAttribute(("data-tag-id")))
				selectedTagIds.push(tagId);
			}
		}

		return selectedTagIds;
	}

	/**
	 * Fetches all project tags in the CMS
	 * @returns {Promise<{id: number, label: string}[]|null>}
	 */
	async FetchProjectTags(){
		const response = await fetch(`/uplift/ipp-form/project-tags`);
		if (response.status === 200){
			const apiData = await response.json();
			return apiData.tags;
		}

		return null;
	}

	/**
	 * Builds a selectable project tag
	 * @param {{id: number, label: string}} tag
	 * @constructor
	 */
	BuildButton(tag){
		const button = document.createElement("button");
		button.classList.add("ipp-form-tag-button");
		button.textContent = tag.label
		button.setAttribute("data-tag-id", tag.id.toString());
		button.setAttribute("type", "button");

		button.addEventListener("click", () => {
			if (button.classList.contains("selected")){
				button.classList.remove("selected");
			}else{
				button.classList.add("selected");
			}
		});

		this.ButtonsContainer.append(button);
	}
}