/**
* Utility class to help get sets of DOM nodes
* for the page editor or the file editor
*/
class DOMHelper{

	/**
	* Gets all the editor tab DOMS on the page editor view
	* @returns {object}
	*/
	static getAllPageEditorTabs(){
		return {
			body: document.querySelector(`.editor-tab[data-window="body"]`),
			head: document.querySelector(`.editor-tab[data-window="head"]`),
			data: document.querySelector(`.editor-tab[data-window="data"]`)
		};
	}

	/**
	* Gets all the ace editors on the theme editor view
	* @returns {object}
	*/
	static getThemeManagerAceEditors(){
		return {
			file: ace.edit(document.querySelector("#file-content"))
		}
	}

	/**
	* Gets the currently active theme manager tab
	* @returns {HTMLButtonElement}
	*/
	static getActiveThemeManagerTab(){
		return document.querySelector(".editor-tab.selected");
	}

	/**
	* Gets all the page windows on the page editor view
	* @returns {{body: HTMLElement, bodySections: HTMLElement, head: HTMLElement, data: HTMLElement}}
	*/
	static getAllPageEditorWindows(){
		return {
			body: document.querySelector("#page-content"),
			bodySections: document.querySelector("#page-sections-content-container"),
			head: document.querySelector("#page-head"),
			data: document.querySelector("#page-data")
		}
	}
}

export default DOMHelper;
