import RecentArticlesModal from "../../page-editor/modals/RecentArticlesModal.js";
import RecentArticlesCategoryButton from "../../page-editor/components/RecentArticlesCategoryButton.js";

export default class RecentArticlesForm{
	constructor() {
		this.form = document.querySelector("#recent-articles-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
	}

	OnSubmit(){
		const fData = new FormData(this.form);
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		// Get all project tags to be included
		const includedArticleCategories = [];
		const includeArticlesCategoryButtonComponents = RecentArticlesCategoryButton.rows;

		for (const buttonComponent of includeArticlesCategoryButtonComponents){
			if (buttonComponent.isSelected){
				includedArticleCategories.push(buttonComponent.categoryID);
			}
		}

		// Get the number of articles per page and columns
		const numRecentArticles = parseInt(String(fData.get("num-recent-articles")));
		const numColumns = parseInt(String(fData.get("recent-articles-num-columns")));
		const autofillArticles = fData.get("recent-articles-autofill"); // "on" or null

		if (isNaN(numRecentArticles)){
			this.OnFormattedError("Number of articles is in a non-numerical format.");
			return;
		}

		if (isNaN(numColumns)){
			this.OnFormattedError("Number of columns is in a non-numerical format.");
			return;
		}

		this.OnSuccess(numRecentArticles, numColumns, includedArticleCategories, autofillArticles);
	}

	/**
	 * When the form succeeds without error
	 */
	OnSuccess(numRecentArticles, numColumns, includedArticleCategories, autofillArticles){
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;
		submitButton.classList.remove("disabled");

		includedArticleCategories = JSON.stringify(includedArticleCategories);
		autofillArticles = autofillArticles === "on" ? 1 : 0;
		const shortcodeText = `{{ get-recent-articles num-articles="${numRecentArticles}" columns="${numColumns}" included-article-categories="${includedArticleCategories}" autofill="${autofillArticles}" }}`
		tinymce.activeEditor.insertContent(shortcodeText);

		RecentArticlesModal.hideModal();
	}

	/**
	 * A readable error happened on the server in the JSON response.
	 * (A status of -1 was read)
	 * @param {string} err
	 */
	OnFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}