import RecentProjectsModal from "../../page-editor/modals/RecentProjectsModal.js";
import RecentProjectsTagButton from "../../page-editor/components/RecentProjectsTagButton.js";

export default class RecentProjectsForm{
	constructor(){
		this.form = document.querySelector("#recent-projects-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
	}

	OnSubmit(){
		const fData = new FormData(this.form);
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		// Get all project tags to be included
		const includedProjectTags = [];
		const includeProjectTagButtonComponents = RecentProjectsTagButton.rows;

		for (let buttonComponent of includeProjectTagButtonComponents){
			if (buttonComponent.isSelected){
				includedProjectTags.push(buttonComponent.tagID);
			}
		}

		// Get the number of articles per page and columns
		const numRecentProjects = parseInt(String(fData.get("num-recent-projects")));
		const numColumns = parseInt(String(fData.get("recent-projects-num-columns")));
		const autofillProjects = fData.get("recent-projects-autofill"); // "on" or null

		if (isNaN(numRecentProjects)){
			this.OnFormattedError("Number of projects is in a non-numerical format.");
			return;
		}

		if (isNaN(numColumns)){
			this.OnFormattedError("Number of columns is in a non-numerical format.");
			return;
		}

		this.OnSuccess(numRecentProjects, numColumns, includedProjectTags, autofillProjects);
	}

	/**
	 * When the form succeeds without error
	 */
	OnSuccess(numRecentProjects, numColumns, includedProjectTags, autofillProjects){
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;
		submitButton.classList.remove("disabled");

		includedProjectTags = JSON.stringify(includedProjectTags);
		autofillProjects = autofillProjects === "on" ? 1 : 0;
		const shortcodeText = `{{ get-recent-projects num-projects="${numRecentProjects}" columns="${numColumns}" included-project-tags="${includedProjectTags}" autofill="${autofillProjects}" }}`
		tinymce.activeEditor.insertContent(shortcodeText);

		RecentProjectsModal.hideModal();
	}

	/**
	 * A readable error happened on the server in the JSON response.
	 * (A status of -1 was read)
	 * @param {string} err
	 */
	OnFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}