import AceEditorExtension from "../AceEditorExtension.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
import FileEditorStates from "./FileEditorStates.js";
import DOMHelper from "../DOMHelper.js";
import EditorFileTab from "./EditorFileTab.js";
import SidebarFileLoader from "./SidebarFileLoader.js";
import DragImportHandler from "./DragImportHandler.js";
import ImageManager from "./../../image-manager/ImageManager.js";
import OpenImageManagerButton from "./components/OpenImageManagerButton.js";
import { ThemeSelector } from "./ThemeSelector.js";

// Modals
import NewDirectoryModal from "./modals/NewDirectoryModal.js";
import NewFileModal from "./modals/NewFileModal.js";
import { LayoutSectionsModal } from "./modals/LayoutSectionsModal.js";

// Forms
import NewDirectoryForm from "./forms/NewDirectoryForm.js";
import NewFileForm from "./forms/NewFileForm.js";
import RenameFileForm from "./forms/RenameFileForm.js";
import RenameDirectoryForm from "./forms/RenameDirectoryForm.js";
import FileEditorForm from "./forms/FileEditorForm.js";
import DirectoryFilterForm from "./forms/DirectoryFilterForm.js";

// PHP variable buttons
import CompanyPhoneNumbersPHPVariableButton from "./php-variable-buttons/CompanyPhone.js";
import PureCompanyPhone from "./php-variable-buttons/PureCompanyPhone.js";
import CompanyFaxNumbersPHPVariableButton from "./php-variable-buttons/CompanyFax.js";
import CompanyNamePHPVariableButton from "./php-variable-buttons/CompanyName.js";
import CompanyStreetPHPVariableButton from "./php-variable-buttons/CompanyStreet.js";
import CompanyPostalPHPVariableButton from "./php-variable-buttons/CompanyPostal.js";
import CompanyCityPHPVariableButton from "./php-variable-buttons/CompanyCity.js";
import CompanyStatePHPVariableButton from "./php-variable-buttons/CompanyState.js";
import CompanyLogoPHPVariableButton from "./php-variable-buttons/CompanyLogo.js";
import MapKeyPHPVariableButton from "./php-variable-buttons/MapKey.js";

class FileEditor{

	/**
	 * @type {?ImageManager}
	 */
	imageManager = null;

	/**
	 * @type {OpenImageManagerButton}
	 */
	openImageManagerButton;

	/**
	 * @type {LayoutSectionsModal}
	 */
	layoutSectionsModal;

	/**
	 * @type {HTMLButtonElement}
	 */
	openLayoutSectionsModalButton = document.querySelector("#layout-sections-button");

	constructor() {

		this.layoutSectionsModal = new LayoutSectionsModal();
		this.loadImageManager();
		this.openImageManagerButton = new OpenImageManagerButton(this);

		// Get the ace editors for the file editor
		const aceEditors = DOMHelper.getThemeManagerAceEditors();

		// Load the extra, custom commands into the editors
		const fileExtension = new AceEditorExtension(aceEditors.file.container, null);

		fileExtension.loadHighlightInnerTag();
		fileExtension.loadLinkize();
		fileExtension.loadBold();
		fileExtension.loadParagraphize();
		fileExtension.loadLinkContextMenu();
		fileExtension.loadPasteFormatter();

		// Event for if there are unsaved changes. Block browser navigation
		window.addEventListener("beforeunload", e => {
			// Check if any tabs have unsaved changes
			for (/** @type {EditorFileTab} */const tab of Object.values(EditorFileTab.registeredButtons)) {
				if (tab.hasUnsavedChanges()) {
					e.preventDefault();
					e.returnValue = "You have unsaved changes. Are you sure you want to leave?";
					return false;
				}
			}
		});

		// Override Ctrl+S for the window
		window.addEventListener("keydown", e => {
			if (e.ctrlKey && e.key.toLowerCase() === "s") {
				e.preventDefault();
				e.stopPropagation();

				// Submit the file editor save form
				FileEditorForm.onSubmit();
			}
		});

		this.openLayoutSectionsModalButton.addEventListener("click", () => {
			this.layoutSectionsModal.showModal();
		});
	}

	loadImageManager(){
		const imageManagerPermInput = document.querySelector("#has-image-manager-perms");
		if (imageManagerPermInput.value === "1"){
			this.imageManager = new ImageManager(document.querySelector("#image-manager-container"));
		}
	}

}

export default new FileEditor();
