import Endpoints from "../../Endpoints.js";

export class ThemeSelector {
	isProcessing = false;

	constructor() {
		const themeSelectorButtons = document.querySelectorAll(".theme-selector-button");

		for(const button of themeSelectorButtons) {
			button.addEventListener("click", () => {
				this.changeTheme(button.getAttribute("id"));
			});
		}
	}

	async changeTheme(theme) {
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const themeForm = new FormData();
		themeForm.set("theme", theme);

		const response = await fetch(`${Endpoints.settings.changeTheme}`, {
			body: themeForm,
			method:"PATCH",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			window.location.reload();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

new ThemeSelector();