import FileEditorStates from "./FileEditorStates.js";

class Utils{
	/**
	 * Gets a path relative to the current theme directory without the full file path showing
	 * @param fullFilePath
	 * @returns {string}
	 */
	static getThemeFileRelativeLocationFromFullPath(fullFilePath){
		fullFilePath = fullFilePath.replace(new RegExp("\\\\", "g"), "/");
		const rootLocation = FileEditorStates.rootThemeDirectory;
		return fullFilePath.replace(rootLocation, "");
	}

	static getFullPathFromRelativeThemePath(relativePath){
		return FileEditorStates.rootThemeDirectory + relativePath;
	}
}

export default Utils;