import PageEditorStates from "../../page-editor/PageEditorStates.js";
import ImageManagerState from "../../../image-manager/ImageManagerState.js";
import ImageManager from "../../../image-manager/ImageManager.js";
import EditorFileTab from "../EditorFileTab.js";
import WindowManager from "../../../image-manager/WindowManager.js";

class OpenImageManagerButton{
	button = document.querySelector("#open-image-manager-button");

	/**
	 * @type {FileEditor}
	 */
	fileEditor;

	/**
	 * @param {FileEditor} fileEditor
	 */
	constructor(fileEditor){
		this.fileEditor = fileEditor;

		this.button.addEventListener("click", () => {
			this.onClicked();
		});
	}

	onClicked(){
		// As a file editor, the image manager should be used to upload images
		// or get their URIs
		// const activeTab = EditorFileTab.getActiveTab();
		// if (activeTab !== null) {
		// 	ImageManagerState.setImageMode(ImageManagerState.IMAGE_MODES.INSERT);
		// }else{
		// 	ImageManagerState.setImageMode(ImageManagerState.IMAGE_MODES.NONE);
		// }
		this.fileEditor.imageManager.imageManagerState.setImageMode(this.fileEditor.imageManager.imageManagerState.IMAGE_MODES.NONE);
		this.fileEditor.imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);
	}
}

export default OpenImageManagerButton;