import FileEditorStates from "../FileEditorStates.js";
import FileEditorWrapper from "../FileEditorWrapper.js";
import ContentChangedHandler from "../../ContentChangedHandler.js";
import Endpoints from "../../../Endpoints.js";
import EditorFileTab from "../EditorFileTab.js";

class FileEditorForm{
	constructor(){
		this.form = document.querySelector("#file-editor-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		const fData = new FormData();

		if (this.isSubmitting){
			return;
		}

		fData.append("file-path", FileEditorStates.currentFilePath);
		fData.append("file-contents", FileEditorWrapper.getCurrentEditorContents());

		const response = await fetch(`/uplift/theme-manager/save-file`, {
			credentials:"same-origin",
			cache:"no-cache",
			method:"patch",
			body:fData
		});

		/** @type {{status: int, error: ?string}} */
		const data = await response.json();

		if (data.status === 1){
			this.onSuccess();
		}else if (data.status === -1){
			this.onFormattedError(data.error);
		}
	}

	/**
	* When the form succeeds without error
	*/
	onSuccess(){
		const activeEditorTab = EditorFileTab.getActiveTab();
		this.isSubmitting = false;
		activeEditorTab.lastSavedValue = activeEditorTab.aceSession.getValue();
		activeEditorTab.hideUnsavedChanges();
		// ContentChangedHandler.hideAllUnsavedChangesIdentifiers();
		// FileEditorStates.unsavedChanges = false;
	}

	/**
	* A readable error happened on the server in the JSON response.
	* (A status of -1 was read)
	* @param {string} err
	*/
	onFormattedError(err){
		this.isSubmitting = false;
		console.log(err);
	}
}

export default (new FileEditorForm);
