import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
import Breadcrumb from "./components/Breadcrumb.js";
import PageContentLoader from "./PageContentLoader.js";

/**
* Functionality for the breadcrumbs buttons
* and breadcrumbs themselves as well as rendering their DOMs
*/
class BreadcrumbsManager{

	/** @type {Breadcrumb[]} */
	breadcrumbs = [];
	addCrumbButton = document.querySelector("#add-crumb-button");

	constructor(){
		this.addCrumbButton.addEventListener("click", () => {
			this.addCrumbButtonClicked();
		});
	}

	addCrumbButtonClicked(){
		// Handle the unsaved changes signal
		ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);

		if (this.breadcrumbs.length === 0){
			this.addBreadcrumb("Home", "/");
		}else{
			this.addBreadcrumb("", this.getURIPrefillForIndex(this.breadcrumbs.length));
		}
	}

	/**
	 * Attempts to infer what the prefilled URI field should be based on the page route.
	 * @param {int} index
	 */
	getURIPrefillForIndex(index){
		const route = PageContentLoader.pageURLInput.value.trim();
		let routeComponents = route.split("/");
		let uriPrefill = "";

		routeComponents = routeComponents.filter(stub => stub !== "");

		if (index === 0){
			return "/";
		}

		if (routeComponents.length >= index) {
			for (let i = 0; i < index; i++) {
				const stub = routeComponents[i];
				uriPrefill += `/${stub}`;
			}

			return uriPrefill;
		}else{
			return "";
		}
	}

	/**
	 * Clears all breadcrumbs and empties the array of them
	 */
	clearBreadcrumbs(){
		for (const breadcrumb of this.breadcrumbs){
			breadcrumb.dom.remove();
		}

		this.breadcrumbs = [];
	}

	/**
	* Adds a new breadcrumb item
	* @param {string} title
	* @param {string} uri
	*/
	addBreadcrumb(title, uri){
		this.breadcrumbs.push(new Breadcrumb(title, uri));
	}

	hideButton(){
		this.addCrumbButton.style.display = "none";
	}

	showButton(){
		this.addCrumbButton.style.display = null;
	}
}

export default (new BreadcrumbsManager);
