import PageEditorStates from "./PageEditorStates.js";
import DOMHelper from "../DOMHelper.js";
import AceEditorExtension from "../AceEditorExtension.js";

/**
* Logic and events for the editor tabs
* above the page editor
*/
class EditorTabs{

	constructor(){

		if (PageEditorStates.viewingState !== ""){

			// Prepare the editor tab events
			const editorTabs = DOMHelper.getAllPageEditorTabs();

			// Connect events to the editor tabs when they are clicked
			for (let windowName of Object.keys(editorTabs)){
				const tab = editorTabs[windowName];
				tab.addEventListener("click", e => {
					this.tabClicked(tab, e);
				});
			}
		}
	}

	/**
	* When an editor tab is clicked
	* @param {DOMNode} tab
	* @param {event} e
	*/
	tabClicked(tab, e){
		const currentWindowName = PageEditorStates.currentEditorWindowName;
		const windowChosen = tab.getAttribute("data-window");
		const pageWindows = DOMHelper.getAllPageEditorWindows();
		const editorTabs = DOMHelper.getAllPageEditorTabs();

		if (currentWindowName !== windowChosen){

			// Get the DOMs for the current and previous windows
			let currentWindow;
			let newWindow;

			if (currentWindowName === "body" && PageEditorStates.currentPageLayoutSectionDefinition !== null){
				currentWindow = pageWindows["bodySections"];
			}else{
				currentWindow = pageWindows[currentWindowName];
			}

			if (windowChosen === "body"){
				// Determine if we should show the main body editor, or the body sections editors
				if (PageEditorStates.currentPageLayoutSectionDefinition !== null){
					newWindow = pageWindows["bodySections"];
					PageEditorStates.currentEditorWindowName = "body";
				}else{
					newWindow = pageWindows[windowChosen];
					PageEditorStates.currentEditorWindowName = windowChosen;
				}
			}else{
				newWindow = pageWindows[windowChosen];
				PageEditorStates.currentEditorWindowName = windowChosen;
			}

			// Visually change which editor tab is selected
			editorTabs[currentWindowName].classList.remove("selected");
			editorTabs[windowChosen].classList.add("selected");

			// Show the new window and hide the current one
			currentWindow.style.display = "none";
			newWindow.style.display = null;

			// Set the current active editor
			if (windowChosen === "body" && PageEditorStates.currentPageLayoutSectionDefinition === null){
				// Current active is the body editor
				PageEditorStates.currentEditor = AceEditorExtension.pageEditors.body;
				AceEditorExtension.pageEditors.body.ace.resize();
			}else if (windowChosen === "head"){
				PageEditorStates.currentEditor = AceEditorExtension.pageEditors.head;
				AceEditorExtension.pageEditors.head.ace.resize();
			}else{
				PageEditorStates.currentEditor = null;
			}
		}
	}
}

export default (new EditorTabs);
