import PageEditorStates from "./PageEditorStates.js";

/**
* An abstract wrapper for other classes and code
* to call methods in order to manipulate
* whatever editor is active for the user.
*/
class EditorWrapper{

	/**
	* Tells if the currently active editor
	* is an instance of the ace editor
	*/
	isActiveEditorAceEditor(){
		return this.isVarAceEditor(PageEditorStates.currentEditor.ace);
	}

	/**
	* Checks if a variable is _probably_
	* an instances of the ace editor
	* @param {object} obj
	*/
	isVarAceEditor(obj){
		// Check for an ace-specific property
		return obj.hasOwnProperty("$behavioursEnabled");
	}

	/**
	* Inserts text to wherever the cursor currently is
	* in the current editor.
	* @param {string} text
	*/
	insertTextAtCursor(text){
		const editor = PageEditorStates.currentEditor.ace;
		if (editor !== null){
			if (this.isActiveEditorAceEditor()){
				// Ace editor
				editor.session.replace(editor.session.getSelection().getRange(), text);
			}
		}
	}

	/**
	* Changes the focus to be in the current active editor
	*/
	focusEditor(){
		const editor = PageEditorStates.currentEditor.ace;
		if (editor !== null){
			if (this.isActiveEditorAceEditor()){
				// Ace editor
				editor.focus();
			}
		}
	}
}

export default (new EditorWrapper);
